--randomize math.random

math.randomseed(os.time())
bb_player = {}
local storage = minetest.get_mod_storage()



--settings
bb_player.spawn = {x=10,y=10,z=10}
bb_player.killdist = 60 -- no map may be bigger than this distance away from the origin or players will die
bb_player.wear_amt = 300 -- amount of wear to add to bad powerups each globalstep
bb_player.debug = false
bb_player.normal_speed = .5-- the speed players start at
bb_player.speed_boost = .2 -- the speed ech speed boost adds
bb_player.speed_snail = .25

-- storage
bb_player.infohuds = {}
bb_player.powerup_huds = {}
bb_player.placebombkeys = minetest.deserialize(storage:get_string("placebombkeys")) or {}

-- api tables
bb_player.registered_before_dieplayers = {}
bb_player.registered_on_dieplayers = {}


local path = minetest.get_modpath("bb_player")
dofile(path.."/api.lua")


-- bb_player.textures = {} -- stores the textures that the player will have in-game (out-game, their textures are clear)


-- --legacy
-- bb_player.saved_colors = minetest.deserialize(storage:get_string("saved_colors")) or {} -- stores the color assigned to the player






-- bb_player.player_colors_avail = {
--     "#472d3c",
--     "#5e3643",
--     "#7a444a",
--     "#a05b53",
--     "#bf7958",
--     "#eea160",
--     "#b6d53c",
--     "#71aa34",
--     "#397b44",
--     "#3c5956",
--     "#5a5353",
--     "#dff6f5",
--     "#8aebf1",
--     "#28ccdf",
--     "#3978a8",
--     "#394778",
--     "#39314b",
--     "#564064",
--     "#8e478c",
--     "#cd6093",
--     "#ffaeb6",
--     "#f4b41b",
--     "#f47e1b",
--     "#e6482e",
--     "#a93b3b",
--     "#827094",
--     "#4f546b",
-- }


-- override the default hand item for shorter reach( so you have to approach a bomb inorder to punch it )



minetest.register_item(":", {
	type = "none",
    range = 1.0,
    groups = {not_in_creative_inventory=1},
})

-- player meta:
-- players can have the following metadata keys:

-- status: can be 
--      "inactive"- they just joined and are waiting for the round to be over. or they have finished a roud and are waiting for some reason
--      "admin" - they are in admin state and cannot play but are not limited as players are
--      "playing" - in-game
--      "dead" - in game but dead and waiting to possibly be respawned if that occurs



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- attachment ent

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



minetest.register_entity("bb_player:att",{
    initial_properties = {
        physical = false,
        use_texture_alpha = true,        
        collisionbox = {-0.01, -0.01, -0.01, 0.01, 0.01, 0.01},
        visual = "sprite",
        textures = {"blank.png"},
        visual_size = {x = 0.01, y = 0.01, z = 0.01},
        static_save = false,
    },
    on_step = function(self, dtime, moveresult)
        
        self._timer = self._timer + dtime
        if self._timer > 300 then
            self.object:remove()
        end
    
    end,

    _timer = 0,

})






--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- allow admins to become admins and regular players again

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

minetest.register_privilege( "admin" , "allows becoming an admin user" )
minetest.register_privilege( "additem" , "allows adding items at yourpostion for testing purposes" )

minetest.register_chatcommand( "admin" , {
    privs = {
        admin = true,
    },
    description = " /admin args: up = become admin user, down = become regular player",
    func = function( name , param )
        local player = minetest.get_player_by_name( name ) 
        if not player then return end
        if param == "up" then
            local pmeta = player:get_meta()
            pmeta:set_string("status", "admin")  
            player:set_physics_override({speed = 1, jump = 1 ,gravity = 70})
        end
        if param == "down" then
            local pmeta = player:get_meta()
            pmeta:set_string("status", "inactive")  
            player:set_pos(bb_player.spawn)
            player:set_physics_override({speed = 0, jump = 0 ,gravity = 0})
        end

    end,
})

minetest.register_chatcommand( "additem" , {
    privs = {
        additem = true,
    },
    description = " additem <itemname> , adds the item to the world at your location (you will pick it up too)",
    func = function( name , param )
        local player = minetest.get_player_by_name( name ) 
        if not player then return end
        local pos = player:get_pos()

        minetest.add_item(pos, param)

    end,
})



minetest.register_chatcommand( "place" , {
    privs = {
        interact = true,
    },
    description = "/place jump = use jump to place bomb /place sneak = use sneak to place bomb (default). Your choice is remembered.",
    func = function( name , param )
        local player = minetest.get_player_by_name( name ) 
        if not player then return end
        if param ~= "jump" and param ~= "sneak" and param ~= "space" and param ~= "shift" then return "[place] Invalid Input" end
        if param == "jump" or param == "space" then bb_player.placebombkeys[name] = "jump" end
        if param == "sneak" or param == "shift" then bb_player.placebombkeys[name] = "sneak" end
        storage:set_string("placebombkeys",minetest.serialize(bb_player.placebombkeys))
        minetest.chat_send_player(name, minetest.colorize("#f47e1b","[!] Your bomb place key is now set to "..bb_player.placebombkeys[name]))

    end,
})




--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- joinplayer

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


minetest.register_on_joinplayer(function(player)
    
    local p_name = player:get_player_name()

    -- set position to the spawn pos
    player:set_pos(bb_player.spawn)

    
    if not bb_player.placebombkeys[p_name] then 
        bb_player.placebombkeys[p_name] = "sneak"
        storage:set_string("placebombkeys",minetest.serialize(bb_player.placebombkeys))
    end

    -- remove this in future versions, its a warning that the placebomb key has changed.
    --%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    minetest.chat_send_player(p_name,minetest.colorize("#f47e1b","[!] ATTN: the new default placebomb key is [sneak]. You can change it back to [jump] with `/place jump`. Your settings are remembered. GUI control coming soon (tm)"))
    --%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    local obj = minetest.add_entity(bb_player.spawn, "bb_player:att")
    player:set_attach(obj)
    -- remove the wielditem and healthbar
    player:hud_set_flags({wielditem=false,healthbar=false,crosshair=false,breathbar=false,minimap=true})
    -- dont allow them to move
    player:set_physics_override({speed = 0, jump = 0 ,gravity = 0})
    --heal fall damage
    player:set_armor_groups({fall_damage_add_percent=-100})
    -- set their status to inactive
    local pmeta = player:get_meta()
    pmeta:set_string("status", "inactive") 
    -- clear their inv
    bb_player.clear_inv(player)

    --start theme
    bb_player.loop_theme("theme",41.1,p_name)



    -- set player privs
    local p_privs = minetest.get_player_privs(p_name)
    if not (p_privs.admin or p_privs.server) then
        p_privs = {
            shout = true,
            interact = true,
        }
    end
    minetest.set_player_privs(p_name, p_privs)

    -- set player skybox
    player:set_sky({
        base_color = "#000000",
        type = "skybox",
        textures = {"Up.jpg", "Down.jpg", "Front.jpg", "Back.jpg", "Right.jpg", "Left.jpg"},
        clouds = false
    })

    player:set_moon({visible = false})
    player:set_sun({visible = false, sunrise_visible = false})

    -- set player hotbar
    player:hud_set_hotbar_selected_image("blank.png")
    player:hud_set_hotbar_image("bb_player_gui_hotbar_2.png")
    player:hud_set_hotbar_itemcount(2)
    -- -- set player model
    -- local player_colors = bb_player.player_colors_avail

    -- local randcolor = player_colors[math.random(1,#player_colors)]

    -- dont change players who have a saved texture


    -- bb_player.saved_colors[p_name] = bb_player.saved_colors[p_name] or randcolor
    -- save for future use
    -- storage:set_string("saved_colors",minetest.serialize(bb_player.saved_colors))

    -- bb_player.textures[p_name] = {"white.png^[colorize:"..bb_player.saved_colors[p_name]..":255","player_parts.png"}

    -- player:set_properties({
    --     visual = "mesh",
    --     mesh = "bb_character.b3d",
    --     textures = {"blank.png","blank.png"},
    --     visual_size = {x = 4, y = 4},
    --     collisionbox = {-0.4, 0.0, -0.4, 0.4, 0.9,0.4},
    --     stepheight = 0.3,
    --     eye_height = 1.3,
    --     physical = false,
    --     collides_with_objects = false,
    -- })


    local status = bb_loop.get_hud_status()

    -- set up the info hud (status and timer/suddendeath)
    bb_player.infohuds[p_name] = player:hud_add({
        hud_elem_type   = "text",
        number          = 0xE6482E,
        position        = { x = .97, y = .03},
        offset          = {x = 0,   y = 0},
        text            = status,
        alignment       = {x = -1, y = 1},  -- change y later!
        scale           = {x = 100, y = 100}, -- covered later
        size            = {x = 2 },
    })

end)



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- player inv sorting

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

minetest.register_globalstep(function(dtime)
    for _,player in pairs(minetest.get_connected_players()) do

        if bb_loop.gamestate == "running" then
        
            local inv = player:get_inventory()
            local list = inv:get_list("main")
            
            local bombs = nil
            local power = nil
            local speed = nil
            local life = nil
            local throw = nil
            local kick = nil
            local multidir = nil
            local bad = nil
            local new_list = {}
            for _,stack in pairs(list) do
                if stack:get_name() == "bb_powerup:extra_bomb" then
                    bombs = stack                
                elseif stack:get_name() == "bb_powerup:extra_power" then
                    power = stack                
                elseif stack:get_name() == "bb_powerup:extra_speed" then
                   speed = stack                
                elseif stack:get_name() == "bb_powerup:extra_life" then
                    life = stack                
                elseif stack:get_name() == "bb_powerup:throw" then
                    throw = stack                
                elseif stack:get_name() == "bb_powerup:kick" then
                    kick = stack                 
                elseif stack:get_name() == "bb_powerup:multidir" then
                    multidir = stack                 
                elseif stack:get_name() ~= "" then
                    bad = stack 
                end
            end

            local counter = 1

            bb_player.clear_inv(player)
            
            if bombs ~= nil then
                inv:set_stack("main", counter, bombs)
                counter = counter + 1
            end
            if power ~= nil then
                inv:set_stack("main", counter, power)
                counter = counter + 1
            end
            if speed ~= nil then 
                inv:set_stack("main", counter, speed)
                counter = counter + 1
            end
            if life ~= nil then
                inv:set_stack("main", counter, life)
                counter = counter + 1
            end
            if throw ~= nil then
                inv:set_stack("main", counter, throw)
                counter = counter + 1
            end
            if kick ~= nil then 
                inv:set_stack("main", counter, kick)
                counter = counter + 1
            end
            if multidir ~= nil then 
                inv:set_stack("main", counter, multidir)
                counter = counter + 1
            end
            if bad ~= nil then
                inv:set_stack("main", counter, bad)
                counter = counter + 1
            end
            local hotbar = counter - 1

            player:hud_set_hotbar_itemcount(hotbar)
            player:hud_set_hotbar_image("bb_player_gui_hotbar_"..hotbar..".png")
        else
            player:hud_set_hotbar_itemcount(2)
            player:hud_set_hotbar_image("bb_player_gui_hotbar_2.png")
        end
    end

end)


--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- player animation

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


-- minetest.register_globalstep(function(dtime)
--     for _, player in pairs(minetest.get_connected_players()) do

--         local meta = player:get_meta()
--         local p_name = player:get_player_name()

        -- if bb_loop.gamestate ~= "running" and bb_loop.gamestate ~= "celebrate" then
        --     -- set player textures to blank if the game is not running
        --     player:set_properties({
        --         textures = {"blank.png","blank.png"},
        --     })

        -- else
        --     if meta:get_string("diestatus") ~= "dead" then
        --         player:set_properties({
        --             textures = bb_player.textures[p_name],
        --         })
        --     end

        -- end

        --if meta:get_string("status") == "playing" then

            --meta:set_string("diestatus", "notdead")
            -- local controls = player:get_player_control()
            -- -- if player is pressing movement keys
            -- if controls.up or controls.down or controls.left or controls.right then
            --     --walk anim
            --     player:set_animation({x=60,y=100}, 50, 0, true)
            -- else
            --     -- stand anim
            --     player:set_animation({x=0,y=40}, 20, 0, true)
            -- end
        -- elseif meta:get_string("status") == "dead" then
            


        --     if meta:get_string("diestatus") ~= "dead" then
                
        --         meta:set_string("diestatus", "dead")
        --         player:set_properties({
        --             textures = {"blank.png","blank.png"},
        --         })

                

        --     end

        -- end

--     end
-- end)


        

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- controls

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function bb_player.try_to_place_bomb(player)

    --get our vars
    if bb_loop.gamestate ~= "running" then return end
	if not player then return end
    local p_name = player:get_player_name()
    local inv = player:get_inventory()
    local pmeta = player:get_meta()
    local p_status = pmeta:get_string("status")
    if p_status ~= "playing" then return end
    local pos = vector.add(player:get_pos(),vector.new(0,.5,0))
    
    
    -- booleans
    -- note: bomb throwing is handled in bomb code
    local can_placebomb = false
    if inv:contains_item("main", "bb_powerup:extra_bomb") and not inv:contains_item("main", "bb_powerup:no_placebomb") then
        can_placebomb = true
    end

    -- if there is a bomb that the player has just placed (they are standing on it) and they have throw ability, then throw it

    local near_bomb = false
    local pos1 = vector.add(pos, vector.new(-.5,0,-.5))
    local pos2 = vector.add(pos, vector.new(.5,0,.5))

    local objs = minetest.get_objects_in_area(pos1, pos2)
    for k,v in ipairs(objs) do
        if v and not ( v:is_player() ) and v:get_luaentity() and v:get_luaentity().name == "bb_bomb:bomb" then
            near_bomb = true
        end
    end


    if can_placebomb and near_bomb ~= true then

        -- place bomb, remove bomb item from inv
        local power = bb_player.get_count_in_inv(player,"bb_powerup:extra_power") 


        if bb_player.debug == true then
            minetest.log("error","power: "..power)
        end


        local multidir = false
        if inv:contains_item("main", ItemStack('bb_powerup:multidir')) then
            multidir = true
            for k,v in pairs(inv:get_list("main")) do 
                if v:get_name() == 'bb_powerup:multidir' then
                    
                    v:add_wear((65535/3)+3)
                    inv:set_stack("main",k,v)
                end
            end
        end


        

        local staticdata = minetest.write_json({
            _power = power,
            _owner = p_name,
            _multidir = multidir,
        })

        minetest.sound_play({
            name = "sfx_sounds_impact4",
            gain = 0.6,
        }, {
            pos = player:get_pos(),
            max_hear_distance = 10,  
        }, true)

        minetest.add_entity(vector.round(pos), "bb_bomb:bomb", staticdata)

        inv:remove_item("main", "bb_powerup:extra_bomb")

    end

end


-- place bomb if no bomb very near and when pressed jump

controls.register_on_press(function(player, control_name)
    local placekey = bb_player.placebombkeys[player:get_player_name()]
    if control_name ~= placekey then return end
    bb_player.try_to_place_bomb(player)
end)



-- implement party powerup (players autoplace bombs whenever they can)

local partytimer = 0
minetest.register_globalstep(function(dtime)
    if bb_loop.gamestate ~= "running" then return end 
    partytimer = partytimer + dtime
    if partytimer > .5 then
        partytimer = 0
        for _, player in pairs( minetest.get_connected_players() ) do
            local inv = player:get_inventory()
            if inv:contains_item("main", "bb_powerup:party") then
                bb_player.try_to_place_bomb(player)
            end
        end
    end
end)


-- special other controls (weird_control)

controls.register_on_press(function(player, control_name)
    if not ( control_name == "left" or control_name == "right" or control_name == "up" or control_name == "down") then
        return
    end
    local inv = player:get_inventory()
    if inv:contains_item("main", "bb_powerup:weird_control") then
        local look = player:get_look_horizontal()
        player:set_look_horizontal(look - 3.14)
    end

end)






--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- globalstep (player handler)

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- set player speed based on inventory contents
-- check for near explosions and kill player


minetest.register_globalstep(function(dtime)
    -- we are only concerned with the running gamestate
    -- iter through all players, but only affect alive and playing players
    local status = bb_loop.get_hud_status()
    for _, player in pairs(minetest.get_connected_players()) do


        --update the status HUD
        local p_name = player:get_player_name()
        player:hud_change(bb_player.infohuds[p_name],"text",status)
        -- since hitpoints does not factor in this game, we will set hp to max
        player:set_hp(300)
        local p_meta = player:get_meta()
        if p_meta:get_string("status") == "playing" and bb_loop.gamestate == "running" then

            --%%%%%%%%%%%%%%%%%%
            --set player speed
            --%%%%%%%%%%%%%%%%%%

            local snail = false
            local superfast = false
            local inv = player:get_inventory()
            local num_speed_boosts = bb_player.get_count_in_inv(player,"bb_powerup:extra_speed")
            -- determine the value of the above variables


            if inv:contains_item("main", ItemStack("bb_powerup:slow")) then
                snail = true
            end
            if inv:contains_item("main", ItemStack("bb_powerup:superfast")) then
                superfast = true
            end

            -- if they have a slow modifier then set their speed to slow
            if snail then
                player:set_physics_override({speed = bb_player.speed_snail, gravity = 70})
            -- if they have a super fast modifier then set their speed to very fast
            elseif superfast then
                player:set_physics_override({speed = 30, gravity = 70})
            -- else just set their speed based on the number of speed boosts they have collected
            else
                local normal_speed = bb_player.normal_speed --.75
                local speed_boost = bb_player.speed_boost -- .5
                local newspeed = normal_speed + num_speed_boosts * speed_boost
                player:set_physics_override({speed = newspeed, gravity = 70})
            end

            --%%%%%%%%%%%%%%%%%%
            --check for nearby explosions, kill players too close
            --%%%%%%%%%%%%%%%%%%

            local pos = player:get_pos()
            local near_exp = false
            local pos1 = vector.add(pos, vector.new(-.5,-.2,-.5))
            local pos2 = vector.add(pos, vector.new(.5,1,.5))
        
            local objs = minetest.get_objects_in_area(pos1, pos2)
            local o = nil -- we will store the explosion objectref in case we need to remove it
            for k,v in ipairs(objs) do
                if v and not ( v:is_player() ) and v:get_luaentity() and v:get_luaentity().name == "bb_bomb:explosion" then
                    near_exp = true
                    o = v
                end
            end
            if near_exp then
                
                -- if there was a nearby explosion, kill them if they dont have extra life. remove it if they do.
                local inv = player:get_inventory()
                if inv:contains_item("main", "bb_powerup:extra_life") == true then
                    
                    if o then -- remove the killing explosion
                        o:remove()
                    end
                    inv:remove_item("main", "bb_powerup:extra_life")
                else
                    --update the players respawn point
                    
                    local pmeta = player:get_meta()
                    pmeta:set_string("spawn", minetest.serialize( player:get_pos() )) 

                    minetest.sound_play({
                        name = "death",
                        gain = 2.0,
                    }, 
                    {
                        pos = player:get_pos(),
                        max_hear_distance = 32,  -- default, uses an euclidean metric
                    }, true)

                    bb_player.kill_player(player,"explosion")

                end
            end

            --%%%%%%%%%%%%%%%%%%
            --check for air under player, move them to center of block and kill them
            --%%%%%%%%%%%%%%%%%%

            local pos = player:get_pos()
            
            if bb_player.check_for_air_under(player) then
                --player:set_pos(vector.add(vector.round(pos),vector.new(0,2,0)))
                local p_props = player:get_properties()

                if bb_player.debug == true then
                    minetest.log("error","player killed for being over air")
                end

                minetest.sound_play({
                    name = "GameOver",
                    gain = 1.0,
                }, {
                    pos = player:get_pos(),
                    gain = 1,  -- default
                    max_hear_distance = 10,  
                }, true)

                -- TODO: play falling sound
                bb_player.kill_player(player,"falling")
            end

            --%%%%%%%%%%%%%%%%%%
            --add wear to time limited powerups
            --%%%%%%%%%%%%%%%%%%

            local inv = player:get_inventory()
            local list = inv:get_list("main")
            --for k, v in pairs(list) do
            for  v = 1 , inv:get_size("main") do
                local stack = inv:get_stack("main", v)
                local i_name = stack:get_name()
                if i_name == "bb_powerup:superfast" or
                    i_name == "bb_powerup:slow" or
                    i_name == "bb_powerup:weird_control" or
                    i_name == "bb_powerup:party" or
                    i_name == "bb_powerup:no_placebomb" then

                    stack:add_wear(bb_player.wear_amt)
                    inv:set_stack("main", v, stack)
                end

            end

            --%%%%%%%%%%%%%%%%%%
            --collect nearby items
            --%%%%%%%%%%%%%%%%%%

            local objs = minetest.get_objects_inside_radius(vector.add(pos,vector.new(0,.5,0)), 0.5)
            for k,v in ipairs(objs) do
                if v and not ( v:is_player() ) and v:get_luaentity() and v:get_luaentity().name == '__builtin:item' then
                    local stack = ItemStack(v:get_luaentity().itemstring)
                    local stack_name = stack:get_name()
                    local goodgroup = minetest.get_item_group(stack_name, "good")
                    local badgroup = minetest.get_item_group(stack_name, "bad")

                    


                    v:remove()


                    -- play sounds
                    if goodgroup == 1 then 
                        minetest.sound_play({
                            name = "yippee",
                            gain = 1.0,
                        }, {
                            pos = player:get_pos(),
                            max_hear_distance = 32,  -- default, uses an euclidean metric
                        }, true)
                    end
                    if badgroup == 1 then 
                        minetest.sound_play({
                            name = "eew",
                            gain = .1,
                        }, {
                            pos = player:get_pos(),
                            max_hear_distance = 32,  -- default, uses an euclidean metric
                        }, true)
                    end

                    -- if there is a bad powerup in the inv, remove it, whenever you get any powerup
                    local list = inv:get_list("main")
                    for l, m in ipairs(list) do
                        local stack = m
                        local i_name = stack:get_name()
                        if i_name == "bb_powerup:superfast" or
                            i_name == "bb_powerup:slow" or
                            i_name == "bb_powerup:weird_control" or
                            i_name == "bb_powerup:party" or
                            i_name == "bb_powerup:no_placebomb" then
        
                            stack:take_item()
                            inv:set_stack("main", l, stack)
                        end
                    end

                    if stack_name == "bb_powerup:resurect" then
                        -- resurrect all players!!!
                        bb_player.resurrect_all_players()                   
                    
                    elseif stack_name == "bb_powerup:throw" or
                        stack_name == "bb_powerup:kick" or
                        stack_name == "bb_powerup:extra_life" or
                        stack_name == "bb_powerup:multidir" then

                            -- if the item is one of the pernament powerups then only add the item if the player doesnt already have one
                            
                        if not(inv:contains_item("main", stack_name)) then
                            inv:add_item("main", stack)
                        end

                    else
                        -- for everything else, we can just add the item
                        inv:add_item("main", stack)
                    end
                end
            end

        -- need to set players' physics override for outside running gamestate (eg, dead or not in game)
        elseif p_meta:get_string("status") ~= "admin" then
            player:set_physics_override({speed = 0, jump = 0 ,gravity = 0})
        end

    end


        

end)



--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-- killplayer stuff

--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bb_player.register_on_dieplayer(function(p_name,cause,death_pos)

    local player = minetest.get_player_by_name(p_name)
    if not player then return end
    -- clear the inv
    bb_player.clear_inv(player)
    -- set meta
    local p_name = player:get_player_name()
    local pmeta = player:get_meta()
    local air_under = false 
    if cause == "falling" then air_under = true end
    
    player:set_physics_override({speed = 0, jump = 0, gravity = 0})
    
    pmeta:set_string("status", "dead") 

    
    --set the player's looking direction to down, so they can watch themselves die >:D
    player:set_look_vertical(0.5 * 3.14)

    -- move the player around: first to watch themselves die from above
    -- then move them to the spectator position
    if bb_loop.current_arena then
        local watch_pos = vector.add(death_pos,vector.new(0,5,0))
        local att = player:get_attach()
        if att then 
            att:set_pos(watch_pos)
        else
            local att = minetest.add_entity(watch_pos, "bb_player:att")
            player:set_attach(att)
        end        
    end

    
    -- after death animation, move them to the spectator position, if the arena is still the same
    minetest.after(3,function(loopcounter,p_name)
        
        if bb_loop.loopcounter == loopcounter then
            --check player exists, they could have ragequit lol
            local player = minetest.get_player_by_name(p_name)

            if player then

                local arena_spectator_pos = bb_loop.current_arena.spectator_pos
                local att = player:get_attach()

                -- we prob. can assume that  att exists, but check, just in case and create it if not
                if att then 
                    att:set_pos(arena_spectator_pos)
                else
                    local att = minetest.add_entity(arena_spectator_pos, "bb_player:att")
                    player:set_attach(att)
                end

            end

        end

    end, bb_loop.loopcounter, p_name )

end)