

local make_desc = function(gem_name, cost,count,longdesc,currency)
    
    local str = minetest.colorize("#a93b3b","Pay:")..
    " "..
    cost.. " "..
    minetest.colorize(gems_battle.get_color_code(gem_name),currency).."\n"..
    minetest.colorize("#3c5956","Get:")..
    " "..
    count.. " ct.".."\n\n"..
    longdesc.."\n"

    return str
end

local get_currency = function(gem_name)
    local currency = ""
    if gem_name == "ruby" then currency = "Rubies" end 
    if gem_name == "emerald" then currency = "Emeralds" end 
    if gem_name == "opal" then currency = "Opals" end 
    if gem_name == "sapphire" then currency = "Sapphires" end 

    return currency
end

gems_battle.prices = {}
gems_battle.prices.gems_stuff = {}
gems_battle.prices.reg_stuff = {}

for _,gem_name in pairs({"ruby","emerald","opal","sapphire"}) do
    gems_battle.prices.gems_stuff[gem_name]={}
    gems_battle.prices.gems_stuff[gem_name]["gems_battle:block_"..gem_name]    = {5 , 1 ,"A strong block that can only \nbe broken with gem picks"}
    gems_battle.prices.gems_stuff[gem_name]["gems_battle:glass_"..gem_name]    = {3 , 1, "A block that is strong \nagainst normal tools"}
    gems_battle.prices.gems_stuff[gem_name]["gems_battle:pick_" .. gem_name]     = {15 , 1, "A pick that is the only way to break Great Gems. \nWorks FASTEST against curr_team Great Gems."}
    gems_battle.prices.gems_stuff[gem_name]["gems_battle:sword_" .. gem_name]    = {18 , 1,"A Powerful Sword. Kills curr_team players faster."}

    gems_battle.prices.gems_stuff[gem_name]["gems_battle:".. gem_name .. "_reveal"]     = {25, 1, "On use, reveals the current location \nof players on curr_team team to all your team members for a short time.\n Recharges slowly."}
    gems_battle.prices.gems_stuff[gem_name]["gems_battle:protector_" .. gem_name]    = {13, 1, "Damages all players in a radius EXCEPT curr_team team players.\n Cannot be placed near other protectors."}
end

gems_battle.prices.reg_stuff["default:pick_steel"] = {3 , 1, "A normal steel Pick. CANNOT break Great Gems!"}
gems_battle.prices.reg_stuff["default:sword_steel"]= {3 , 1, "A normal steel Sword"}
gems_battle.prices.reg_stuff["default:axe_steel"]  = {3 , 1, "A normal steel Axe"}
-- gems_battle.prices.reg_stuff[bronze_pick  ]= {2 , 1}
-- gems_battle.prices.reg_stuff[bronze_sword ]= {2 , 1}

-- gems_battle.prices.reg_stuff[bronze_axe   ]= {2 , 1}

gems_battle.prices.reg_stuff["default:stone"]       = {1 , 5, "Stone - A good building material"}
gems_battle.prices.reg_stuff["default:obsidian"]    = {1 , 2, "Obsidian - A tough block"}
gems_battle.prices.reg_stuff["default:wood"]        = {1 , 5, "Wood - A good building material"}
gems_battle.prices.reg_stuff["default:tree"]        = {1 , 2, "Tree - A tough block"}
gems_battle.prices.reg_stuff["default:glass"]       = {1 , 5, "Glass - A good building material"}
gems_battle.prices.reg_stuff["default:obsidian_glass" ]= {1 , 3, "Obsidian Glass - Can only be broken with a pick"}

gems_battle.prices.reg_stuff["default:apple"]       = {4 , 1, "Heals one heart. Cooldowns apply"}

gems_battle.prices.reg_stuff["enderpearl:ender_pearl"]= {22, 1, "Enderpearl - \nTeleports you when thrown"}
gems_battle.prices.reg_stuff["default:torch"]        = {3, 1, "Torch - \nLight up those dark spaces"}

-- gems_battle.prices.gem_shield   = {18, 1}
gems_battle.prices.reg_stuff["3d_armor:helmet_steel" ]   = {5 , 1, "Helmet - \nA good protection against damage"}
gems_battle.prices.reg_stuff["3d_armor:chestplate_steel"]= {6 , 1,"Chestplate - \nA good protection against damage"}
gems_battle.prices.reg_stuff["3d_armor:leggings_steel" ] = {6 , 1,"Leggings - \nA good protection against damage"}
gems_battle.prices.reg_stuff["3d_armor:boots_steel" ]    = {5 , 1,"Boots - \nA good protection against damage"}



-- build our detached shop invs


for _,gem_name in pairs({"ruby","emerald","opal","sapphire"}) do

    -- the string for plural of gem_name
    local currency = get_currency(gem_name)

    minetest.create_detached_inventory("shop_"..gem_name, {
        allow_move = function(inv, from_list, from_index, to_list, to_index, count, player) return 0 end,
        allow_put = function(inv, listname, index, stack, player) return 0 end,
        allow_take = function(inv, listname, index, stack, player)
            local p_inv = player:get_inventory()
            local s_meta = stack:get_meta()
            local s_cost = s_meta:get_int("cost")
            local coststack = ItemStack("gems_battle:"..gem_name)
            coststack:set_count(s_cost)
            local taken = p_inv:remove_item("main", coststack)

            if taken:get_count() == coststack:get_count() then
                p_inv:add_item("main",stack)
                return 0
            else
                p_inv:add_item("main", taken)
                minetest.chat_send_player(player:get_player_name(),minetest.colorize("#f47e1b", "[!] You don't have enough "..currency.."!"))
                return 0
            end
        end,
        -- Called when a player wants to take something out of the inventory.
        -- Return value: number of items allowed to take.
        -- Return value -1: Allow and don't modify item count in inventory.   

        on_take = function(inv, listname, index, stack, player)
            local p_inv = player:get_inventory()
            local list = p_inv:get_list("main")
            for i,stack in pairs(list) do
                local meta = stack:get_meta()
                local revert = meta:get_string("revert_desc")
                if revert then 
                    meta:set_string("description",revert)
                    meta:set_string("revert_string","")
                    p_inv:set_stack("main", i, stack)
                end
            end
        end,
    })

    local inv = minetest.get_inventory({type="detached", name="shop_"..gem_name})
    local newlist = {}
    for i=1,8*4 do
        table.insert(newlist,ItemStack(""))
    end

    inv_inc = 1
    for item,cost_data in pairs(gems_battle.prices.gems_stuff[gem_name]) do
        local cost = cost_data[1]
        local count = cost_data[2]
        local longdesc = string.gsub(cost_data[3],"curr_team",minetest.colorize(gems_battle.get_color_code(gem_name),gem_name))
       
        local entry = ItemStack(item.." "..count)
        local entrymeta = entry:get_meta()
        entrymeta:set_string("description", make_desc(gem_name,cost,count,longdesc,currency))
        entrymeta:set_int("cost",cost)
        entrymeta:set_string("revert_desc",longdesc)
        newlist[inv_inc] = entry
        inv_inc = inv_inc + 1
    end
    for item,cost_data in pairs(gems_battle.prices.reg_stuff) do
        local cost = cost_data[1]
        local count = cost_data[2]
        local longdesc = string.gsub(cost_data[3],"curr_team",minetest.colorize(gems_battle.get_color_code(gem_name),gem_name))
        
        local entry = ItemStack(item.." "..count)
        local entrymeta = entry:get_meta()
        entrymeta:set_string("description", make_desc(gem_name,cost,count,longdesc,currency))
        entrymeta:set_int("cost",cost)
        entrymeta:set_string("revert_desc",longdesc)
        newlist[inv_inc] = entry
        inv_inc = inv_inc + 1
    end


    inv:set_list("main", newlist)

end




function gems_battle.show_shop_formspec(team, currency , player )

    
    local fs = {
        "formspec_version[4]",
        "size[10.75,15]",
        "no_prepend[]",
        "bgcolor[#FFFFFF88;true;#FFFFFF88]",
        "background[0,0;10.75,15;gems_shop_bg.png;false]",
        "model[.5,.3;1.8,2.8;keeper;character.b3d;shopkeeper_"..team..".png;0,-150;false;false;x=0,y=0;0]",
        "label[4.7,1.1;Hi! Bring me "..minetest.colorize(gems_battle.get_color_code(team), currency).." and]",
        "label[4.7,1.8;I will sell you my wares!]",
        "label[4.7,2.5;Just take whatever you like!]",
        "list[detached:shop_"..team..";main;.5,3.75;8,4;]",
        "list[current_player;main;.5,9.75;8,4;]", 
        "listring[]"           
    }

    minetest.show_formspec(player:get_player_name(), "shop_"..team, table.concat(fs))

end
