local gem_names = gems_battle.team_names
local gem_names_caps = gems_battle.team_names_caps

if minetest.get_modpath("3d_armor") then

    for _ , gem_name in pairs(gem_names) do

        local gem_name_cap = gem_names_caps[_]
        armor:register_armor("gems_battle:shield_"..gem_name, {
            description = gem_name_cap .. " Shield",
            inventory_image = "gems_inv_shield_"..gem_name..".png",
            groups = {armor_shield=1, armor_heal=7, armor_use=200,not_in_creative_inventory = 1},
            armor_groups = {fleshy=15},
            damage_groups = {cracky=2, snappy=1, choppy=1, level=3},
            on_damage = function(player, index, stack)
                --play_sound_effect(player, "default_glass_footstep")
            end,
            on_destroy = function(player, index, stack)
                --play_sound_effect(player, "default_break_glass")
            end,
            on_use = function(itemstack, user, pointed_thing)
                if user and user:is_player() then
                    local weared_elems = armor:get_weared_armor_elements(user)
                    if weared_elems["shield"] then
                        armor:unequip (user, "shield")
                    end
                    local itemstack = armor:equip (user, itemstack)
                    return itemstack
                end
            end,
        })

    end

end

-- detect the version of 3d armor used (mod or modpack)
local steel_armor = "3d_armor"
local steel_leggings = steel_armor..":leggings_steel"

-- if not minetest.registered_items[steel_leggings] then
--     steel_armor = "armor_steel"
--     steel_leggings = steel_armor..":leggings_steel"
-- end

local armors = {"leggings", "helmet", "chestplate", "boots"}
for _,armor in pairs(armors) do
    minetest.override_item(steel_armor..":"..armor.."_steel", {
        on_use = function(itemstack, user, pointed_thing)
            if user and user:is_player() then
                local weared_elems = armor:get_weared_armor_elements(user)
                if weared_elems[armor] then
                    armor:unequip (user, armor)
                end
                local itemstack = armor:equip (user, itemstack)
                return itemstack
            end
        end,
    })
    
end
