

-- grapple throwable

minetest.register_entity("grapple:grapple_throwable",{
    initial_properties = {
        visual = "mesh",
        mesh = "grapple.obj",
        physical = true,
        visual_size = {x=1,y=1},
        hp_max = 50,
        textures = {"grapple_black.png"},
        collisionbox = {-.25,-.25,-.25,.25,.25,.25},
        -- static_save = false,
    },
    _player = "",
    _timer = 0,
    _id = 0,
    _remove = false,
    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir, damage)
        if puncher and self._timer > 1 then 
            if not(self._id) then self.object:remove() end
            grapple.return_grapple(self._player,self._id)
        end
    end,

    on_step = function(self,dtime,moveresult)

        if self._remove == true then self.object:remove() return end

        local player = minetest.get_player_by_name(self._player)

        if not player then self._remove = true return end

        self._timer = self._timer + dtime

        -- if self._timer > 0 

        if self._id == 0 then self._remove = true return end
        if not(grapple.players[self._player] ) then self._remove = true return end

        local id_found = false
        for _,grappledata in pairs(grapple.players[self._player].grapples) do
            if grappledata.id == self._id then
                id_found = true 
                
                grappledata.p1 = self.object:get_pos()
                grappledata.p2 = player:get_pos()
                if not grappledata.rope_spawned then
                    grappledata.rope_spawned = true
                    -- local mid = grapple.midpoint(grappledata.p1,grappledata.p2)
                    minetest.add_entity(grappledata.p1, "grapple:rope", minetest.write_json({
                        _player = self._player,
                        _id = self._id,
                    }))
                end

            end
        end

        if not id_found then self._remove = true return end






        -- handle collisions

        if moveresult and self._id ~= 0 then
            for _,collision in pairs(moveresult.collisions) do

                if collision.type == "object" then
                    -- hit object, attach the object to a solid grapple
                    -- check if the object is fleshy
                    local armour_groups = collision.object:get_armor_groups()
                    if armour_groups.fleshy > 0 then 
                        local meta = minetest.write_json({
                            _player = self._player,
                            _id = self._id,
                        })
                        local pos = collision.object:get_pos()
                        local obj = minetest.add_entity(pos, "grapple:grapple_hook", meta)    
        
                        -- obj:set_attach(collision.object,nil,nil,nil,true)
                        collision.object:set_attach(obj,nil,nil,nil,true)

                        for _,grappledata in pairs(grapple.players[self._player].grapples) do
                            if grappledata.id == self._id then
                                grappledata.stuck = true
                                grappledata.type = "object"
                            end
                        end

                        self._remove = true
                        return

                    end
                end
                if collision.type == "node" then
                    local meta = minetest.write_json({
                        _player = self._player,
                        _id = self._id,
                    })
                    local pos = self.object:get_pos()
                    local obj = minetest.add_entity(pos, "grapple:grapple_hook", meta)    
                    obj:set_rotation(self.object:get_rotation())

                    for _,grappledata in pairs(grapple.players[self._player].grapples) do
                        if grappledata.id == self._id then
                            grappledata.stuck = true
                            grappledata.type = "node"
                        end
                    end

                    local meta = minetest.write_json({
                        _player = self._player,
                        _id = self._id,

                    })
                    local pos = player:get_pos()
                    local obj = minetest.add_entity(pos, "grapple:player_att", meta)  
                    player:set_attach(obj)

                    self._remove = true
                    return
                end
            end
        end


    end,

    on_activate = function( self, staticdata, dtime_s)
        if staticdata ~= "" and staticdata ~= nil then
            local data = minetest.parse_json(staticdata) or {}
            if data and data._player then 
                self._player = data._player
                self._id = data._id
            end
        end
    end,



})









-- solid grapple (hooked)

minetest.register_entity("grapple:grapple_hook",{
    initial_properties = {
        visual = "mesh",
        mesh = "grapple.obj",
        physical = true,
        visual_size = {x=1,y=1},
        hp_max = 50,
        textures = {"grapple_black.png"},
        collisionbox = {-.25,-.25,-.25,.25,.25,.25},
        stepheight = 1,

    },
    _player = "",
    _id = 0,
    _remove = false,
    _velocity = 0,
    on_punch = function(self, puncher, time_from_last_punch, tool_capabilities, dir, damage)
        if puncher then 
            if not(self._id) then self.object:remove() end
            grapple.return_grapple(self._player,self._id)
            self._remove = true
        end
    end,

    on_step = function(self,dtime,moveresult)

        if self._remove == true then 
            self.object:remove() 
            return
        end

        if self._id == 0 then self.object:remove() return end

        if not(grapple.players[self._player] ) then self.object:remove() return end

        local player = minetest.get_player_by_name(self._player)
        if not player then self.object:remove() return end

        local id_found = false
        for _,grappledata in pairs(grapple.players[self._player].grapples) do
            if grappledata.id == self._id then
                id_found = true 
                
                if grappledata.pull == true then
                    if grappledata.type and grappledata.type == "object" then


                        grappledata.pull = false
                        grappledata.pull_timer = 2 -- timeout
                        self._velocity = self._velocity + 3
                        
                    end
                end

                -- update for lasso visual
                grappledata.p1 = self.object:get_pos()
                grappledata.p2 = player:get_pos()
                if self._velocity > 0 then
                    self.object:set_velocity(vector.multiply(vector.direction(grappledata.p1,grappledata.p2),self._velocity))
                end
                if vector.distance(grappledata.p1,grappledata.p2) < 2 then
                    self.object:set_velocity(vector.zero())
                    self._velocity = 0
                end

            end
        end

        if not id_found then self.object:remove() return end
        

    end,

    on_activate = function( self, staticdata, dtime_s)
        if staticdata ~= "" and staticdata ~= nil then
            local data = minetest.parse_json(staticdata) or {}
            if data and data._player then 
                self._player = data._player
                self._id = data._id
            end
        end      
    end,



})





-- rope entity

minetest.register_entity("grapple:rope",{
    initial_properties = {
        visual = "mesh",
        mesh = "grapple_rope_2.b3d",
        physical = false,
        immortal = true,
        hp_max = 32,
        textures = {"blank.png"},
        collisionbox = {-.1,-.1,-.1,.1,.1,.1},
        static_save = false,
    },
    
    _player = "",
    _id = 0,
    _timer = 0,

    on_activate = function( self, staticdata, dtime_s)
        if staticdata ~= "" and staticdata ~= nil then
            local data = minetest.parse_json(staticdata) or {}
            if data and data._player then 
                self._player = data._player
                self._id = data._id
            end
        end
    end,

    on_step = function(self,dtime)
        self._timer = self._timer + dtime
        if self._timer > .5 then
            self.object:set_properties({textures={"grapple_black.png"}})
        end
        if not self._player then self.object:remove() return end
        if not self._id then self.object:remove() return end
        if not grapple.players[self._player] then self.object:remove() return end
        

        local id_found = false
        for _,grappledata in pairs(grapple.players[self._player].grapples) do
            if grappledata.id == self._id then
                id_found = true 
                
                if grappledata.p1 then
                    self:_set_orientation(grappledata.p1,grappledata.p2)
                end

            end
        end

        if not id_found then self.object:remove() return end
    end,

    _set_orientation = function(self,p1,p2)

        local rot = vector.dir_to_rotation(vector.direction(p1, p2))
        self.object:set_pos(p1)
        self.object:set_rotation(rot)
        self.object:set_properties({
            visual_size = {x = 6, z = 10 * vector.distance(p2, p1), y = 6}
        })

    end
})



-- attachment for players to ride
minetest.register_entity("grapple:player_att",{
    initial_properties = {
        visual = "sprite",
        physical = true,
        hp_max = 32,
        textures = {"blank.png"},
        collisionbox = {-.1,-.1,-.1,.1,.1,.1},
        stepheight = 1,
    },
    
    _player = "",
    _id = 0,
    _velocity = 0,
    _target = nil,

    on_activate = function( self, staticdata, dtime_s)
        if staticdata ~= "" and staticdata ~= nil then
            local data = minetest.parse_json(staticdata) or {}
            if data and data._player then 
                self._player = data._player
                self._id = data._id
            end
        end
    end,


    on_step = function(self,dtime)
        if not self._player then self.object:remove() return end
        if not self._id then self.object:remove() return end
        if not grapple.players[self._player] then self.object:remove() return end
        local player = minetest.get_player_by_name(self._player)
        if not player then self.object:remove() return end
        local id_found = false
        for _,grappledata in pairs(grapple.players[self._player].grapples) do
            if grappledata.id == self._id then
                id_found = true 


                if vector.distance(grappledata.p1,grappledata.p2) < 2 then
                    self.object:set_velocity(vector.zero())
                else

                    if grappledata.pull == true then
                        if grappledata.type and grappledata.type == "node" then
                            grappledata.pull = false
                            grappledata.pull_timer = 2 -- timeout
                            -- attached to a node to pull player towards
                            self._velocity = self._velocity + 3
                            self._target = grappledata.p1

                        end
                    end

                end
            end
        end

        if not id_found then self.object:remove() return end

        if self._target and player:get_attach() then
            self.object:set_yaw(player:get_look_horizontal())
            player:get_attach():set_velocity(vector.multiply(vector.direction(player:get_pos(),self._target),self._velocity))
        end

    end,

})