
arena_lib.register_editor_section("wormball", {

    name = "wormball_settings",
    icon = "wormball_menu.png",
    hotbar_message = "Wormball Arena Settings",
    give_items = function(itemstack, user, arena)
        local tbl = {"wormball:pos1","wormball:pos2"}
        return tbl
    end,
})


minetest.register_tool("wormball:pos1",{

    description = "Area to Clear Pos 1",
    inventory_image = "wormball_pos1.png",
    wield_image = "wormball_pos1.png",
    groups = {not_in_creative_inventory = 1},
    on_place = function() end,
    on_drop = function() end,

    on_use = function(itemstack, user, pointed_thing)

        local mod = user:get_meta():get_string("arena_lib_editor.mod")
        local arena_name = user:get_meta():get_string("arena_lib_editor.arena")
        local pos = vector.floor(user:get_pos())
        local pos_string = '{ x = '..pos.x .. ", y = " .. pos.y .. ", z = " .. pos.z .. "}" 
        
        arena_lib.change_arena_property(user:get_player_name(), 'wormball', arena_name, "area_to_clear_after_game_pos_1", pos_string , true)
        minetest.chat_send_player(user:get_player_name(), "Pos_1 has been set to :"..dump(pos))  
    end
})


minetest.register_tool("wormball:pos2",{

    description = "Area to Clear Pos 2",
    inventory_image = "wormball_pos2.png",
    wield_image = "wormball_pos2.png",
    groups = {not_in_creative_inventory = 1},
    on_place = function() end,
    on_drop = function() end,

    on_use = function(itemstack, user, pointed_thing)

        local mod = user:get_meta():get_string("arena_lib_editor.mod")
        local arena_name = user:get_meta():get_string("arena_lib_editor.arena")
        local pos = vector.floor(user:get_pos())
        local pos_string = '{ x = '..pos.x .. ", y = " .. pos.y .. ", z = " .. pos.z .. "}" 
        arena_lib.change_arena_property(user:get_player_name(), 'wormball', arena_name, "area_to_clear_after_game_pos_2", pos_string , true)        minetest.chat_send_player(user:get_player_name(), "Pos_2 has been set to :"..dump(pos)) 
        minetest.chat_send_player(user:get_player_name(), "Pos_2 has been set to :"..dump(pos)) 
    end
})