-- scoreboards
local storage = wormball.storage

wormball.show_multi_scores = function( arena , player , scores )

    local leaderboard = scores
    --minetest.chat_send_all(dump(arena))
    local player_list = ""

    if not leaderboard or not leaderboard[1] then return end

    for idx , winner_table in ipairs( leaderboard ) do
        local max_len = 30
        local p_name = winner_table [ 2 ]
        local name_len = string.len( winner_table [ 2 ] )
        if name_len > 20 then
            p_name = string.sub(p_name, 1, 20)
            name_len = 20
        end
        local pts = tostring( winner_table [ 1 ] )
        local pts_len = string.len( pts )
        local spaces = max_len - name_len - pts_len

        player_list = player_list .. p_name 
        for i = 1, spaces do
            player_list = player_list .. " "
        end
        player_list = player_list .. pts .. ","

    end

    local formspec = "formspec_version[4]"..
    "size[8,9]"..
    "box[0,0;8,1;#ff4800]"..
    "label[2.5,0.5;Multiplayer Scores]"..
    "box[0,1;8,1;#ff8000]"..
    "label[3,1.5;" .. arena.name .. "]"..
    "box[0,2;8,7;#191359]"..
    "textlist[0.5,2.5;7,6;;".. player_list ..";1;true]"

    minetest.show_formspec(player, 'multiscoreboard', formspec)


end


wormball.show_singleplayer_leaderboard = function( arena_name , playername )

    if not arena_lib.get_arena_by_name('wormball', arena_name ) then return false end
    local arena_id, arena = arena_lib.get_arena_by_name('wormball', arena_name )
    local leaderboard = arena.singleplayer_leaderboard
    --minetest.chat_send_all(dump(arena.singleplayer_leaderboard))
    local player_list = ""

    if not leaderboard or not leaderboard[1] then return end

    for idx , winner_table in ipairs( leaderboard ) do
        local max_len = 30
        local p_name = winner_table [ 2 ]
        local name_len = string.len( winner_table [ 2 ] )
        if name_len > 20 then
            p_name = string.sub(p_name, 1, 20)
            name_len = 20
        end
        local pts = tostring( winner_table [ 1 ] )
        local pts_len = string.len( pts )
        local spaces = max_len - name_len - pts_len

        player_list = player_list .. p_name 
        for i = 1, spaces do
            player_list = player_list .. " "
        end
        player_list = player_list .. pts .. ","

    end

    local formspec = "formspec_version[4]"..
    "size[8,9]"..
    "box[0,0;8,1;#ff4800]"..
    "label[3,0.5;Leaderboard]"..
    "box[0,1;8,1;#ff8000]"..
    "label[3,1.5;" .. arena_name .. "]"..
    "box[0,2;8,7;#191359]"..
    "textlist[0.5,2.5;7,6;;".. player_list ..";1;true]"

    minetest.show_formspec(playername, 'scoreboard', formspec)

end







































arena_lib.on_celebration('wormball', function(arena, winner_name)

    --reset player textures back to the texture they were... (wormball sets player textures to clear)

    for pl_name,stats in pairs(arena.players) do
        if not(arena_lib.is_player_spectating(pl_name)) then
            wormball.detach(pl_name)
        end
    end

    

    --for now, arena_lib only supports single winners... change this when it supports multiple winners

    if type(winner_name) == 'string' then


        if arena.mode == 'singleplayer' then

            -- leaderboard will be a table with the following format 
            -- {
            --    {score,plname}
            --    {score,plname}
            --   }

            -- it will always be ordered, with the highest score first.

            local new_highscore = false

            local leaderboard = arena.singleplayer_leaderboard

            local score = arena.players [ winner_name ] .score

            if not leaderboard then leaderboard = {} end

            if # leaderboard == 0 then
                leaderboard [ 1 ] = { score , winner_name }
                new_highscore = true
            else

                local insert = true

                for idx , winner_table in ipairs( leaderboard ) do

                    if winner_table [ 2 ] == winner_name then --if the player already has a score on the board...

                        if score > winner_table[1] then -- new higher score achieved... we will now remove the old score so we can input the new score at the correct location
                            table.remove(leaderboard , idx )
                        else -- the score wasn't higher, so no need to insert a new score
                            insert = false
                        end

                    end

                end

                if insert then

                    for idx , winner_table in ipairs( leaderboard ) do
                        if score > winner_table [ 1 ] then 
                            table.insert( leaderboard , idx , { score , winner_name } )
                            if idx == 1 then
                                new_highscore = true
                            end
                            break
                        end
                    end

                end
            end

            --arena_lib.change_arena_property(winner_name, 'wormball', arena.name, "singleplayer_leaderboard", leaderboard)

            --arena_lib.change_arena_property('wormball' , 'wormball' , arena.name , "singleplayer_leaderboard" , leaderboard )

            --save (update) the highscore data to disk
            arena.singleplayer_leaderboard = leaderboard
                        
            local serial = minetest.serialize(arena.singleplayer_leaderboard)

            storage:set_string(arena.name .. "_highscores", serial )






            if new_highscore then
                arena_lib.HUD_send_msg_all("title", arena, 'New High Score!', 2 ,'sumo_win',0xAEAE00)
            else
                arena_lib.HUD_send_msg_all("title", arena, 'Game Over!', 2 ,'sumo_win',0xAEAE00)
            end

            minetest.after( 3 , function( arena , score , leaderboard ) 

                arena_lib.HUD_send_msg_all("title", arena , 'You had ' .. score .. ' pts!', 3 ,'sumo_win',0xAEAE00)

                

                minetest.after( 3 , function( arena , score , leaderboard ) 

                    for pl_name , stats in pairs(arena.players_and_spectators) do
                        wormball.show_singleplayer_leaderboard( arena.name , pl_name )
                    end
                    
                end , arena , score , leaderboard )

                

            end , arena , score , leaderboard )

        else --arena.mode == 'multiplayer'

            arena_lib.HUD_send_msg_all("title", arena, 'New High Score!', 2 ,'sumo_win',0xAEAE00)

            table.insert( arena.multi_scores , 1 , { arena.players[ winner_name ] .score , winner_name } ) 

            local scores = arena.multi_scores



            if minetest.get_modpath( 'panel_lib' ) then
            
                minetest.after( 2 , function( arena , scores ) 
                    
                    for pl_name , stats in pairs(arena.players_and_spectators) do
                        wormball.show_multi_scores( arena , pl_name , scores )
                    end
                      
                    -- show the scoreboard here
                    
                end , arena , scores )

            end
        end
















    --     --Highscores are stored per number of players...
        
    --     --in a crash report, highscore was nil... WHY!? #BUG
    --     --crash (hopefully) prevented with nil check... place debug code here
    --     --note: crash occured when arena edit mode was entered while arena had crashed due to another bug, and the arena was still active (in_celebration)
    --     --note2: this will also prevent crashes due to arena editors messing with the highscores table.
        
    --     local highscore = arena.highscores[arena.num_players]
    --     if not highscore then  --nil check
    --         local highscore_tbl = arena.highscores
    --         highscore_tbl[arena.num_players] = {'pl_name_placeholder',0}
    --         arena_lib.change_arena_property(nil, 'wormball', arena.name, highscores, highscore_tbl)

    --         if arena.mode == 'singleplayer' then
    --             local splb = arena.singleplayer_leaderboard
    --             table.insert(splb, {})

    --         highscore = {'pl_name_placeholder',0}
    --     end

    --     --old highscore info if existing
    --     local high_name = highscore[1] or '' 
    --     local high_num = highscore[2] or 0

    --     --current winner pts
    --     local winner_pts = arena.players[winner_name].score

    --     --HUD info sent to players
    --     arena_lib.HUD_send_msg_all("title", arena, winner_name..' won with '..winner_pts.. ' pts!', 9,'sumo_win',0xAEAE00)
    --     arena_lib.HUD_send_msg_all("hotbar", arena, 'Highscore: '..high_name.. ' '..high_num, 9,nil,0x0000FF)

    --     --if highscore was broken, 2 sec later, another HUD info abt that...
    --     if high_num < winner_pts then
    --         --set highscore info
    --         arena.highscores[arena.num_players] = {winner_name,winner_pts} --could this have cause the bug?
    --         minetest.after(2,function(arena,winner_name,winner_pts)
    --             arena_lib.HUD_send_msg_all("title", arena, 'NEW HIGH SCORE '.. arena.num_players ..' PLAYER!', 7,'sumo_win',0xAEAE00)
    --             arena_lib.HUD_send_msg_all("hotbar", arena, 'Highscore: '..winner_name.. ' '..winner_pts, 7,nil,0x0000FF)
    --         end,arena,winner_name,winner_pts)
    --     end

    end

end)


