local S = core.get_translator("colour_jump")
local modname = "colour_jump"

colour_jump = {}
colour_jump.HUD = {}
arena_lib.register_minigame( modname , {
    name = S("Colour Jump"),
    icon = "colour_jump_icon.png",

    min_players = 2,
    time_mode = 'incremental',
    celebration_time = 5,
    disabled_damage_types = {"fall","punch","set_hp"},
    camera_mode = "third",

    in_game_physics = {
        speed = 1.5,
        sneak_glitch = true,
        new_move = false,
    },

    properties = {
            platforms = {}, -- e.g. {pos = {x,y,z}, node="wool:red", id="Red", hexColor="0xFF1616"},
            y = 0,
            timer_initial_duration = 6,
            timer_min_duration = 1.5,
            timer_decrease_value = 0.5,
            initial_waiting_time = 7,
            waiting_time_min_duration = 1,
            waiting_time_decrease_value = 0.5,
        },

    temp_properties = {
        curr_platforms_data = {},
        timer_current = 0,
        waiting_time_current = 0,
        seconds_left = 0,
        rounds_counter = 0,
        last_hud_seconds = -1, -- last number of seconds shown in HUD to prevent
                                -- sending the same message over and over
    },
})

--====================================================
--====================================================
--            Calling the other files
--====================================================
--====================================================


local srcpath = core.get_modpath(modname) .. "/src/"

dofile(srcpath .. "core.lua")
dofile(srcpath .. "HUD.lua")
dofile(srcpath .. "privs.lua")
dofile(srcpath .. "arena_lib/arena_editor.lua")
dofile(srcpath .. "arena_lib/on_celebration.lua")
dofile(srcpath .. "arena_lib/on_enable.lua")
dofile(srcpath .. "arena_lib/on_load.lua")
dofile(srcpath .. "arena_lib/on_quit.lua")
dofile(srcpath .. "arena_lib/on_time_tick.lua")



-- Legacy update: avoid old maps to crash the server, disabling them instead
for ar_name, ar in pairs(arena_lib.mods["colour_jump"].arenas) do
    if ar.enabled and not next(ar.platforms) then
        arena_lib.disable_arena("", "colour_jump", ar_name)
    end
end