local S = core.get_translator("colour_jump")

local function show_waypoints() end
local function remove_waypoints() end

local waypoints = {} -- KEY: player name; VALUE: {waypoints IDs}
local PLATFORMS_DATA = {
  {node = "wool:white", col = S("White"), hex = "0xFFFFFF"},
  {node = "wool:blue", col = S("Blue"), hex = "0x0C2DFD"},
  {node = "wool:green", col = S("Green"), hex = "0x3EF23B"},
  {node = "wool:red", col = S("Red"), hex = "0xFF1616"},
  {node = "wool:yellow", col = S("Yellow"), hex = "0xFFF415"},
  {node = "wool:cyan", col = S("Sky Blue"), hex = "0x21CCD7"},
  {node = "wool:pink", col = S("Pink"), hex = "0xDDBDC6"},
  {node = "wool:grey", col = S("Grey"), hex = "0x9A9A9A"},
  {node = "wool:magenta", col = S("Magenta"), hex = "0xCC00CC"},
}


arena_lib.on_join_editor("colour_jump", function(arena, p_name)
  show_waypoints(p_name, arena)
end)



arena_lib.on_leave_editor("colour_jump", function(arena, p_name)
  remove_waypoints(p_name, arena)
end)



arena_lib.register_editor_section("colour_jump", {
  name = S("Platforms"),
  icon = "colour_jump_editor.png",
  give_items = function(itemstack, user, arena) return {"colour_jump:editor_platforms"} end
})





core.register_tool("colour_jump:editor_platforms", {

  description = S("LMB create platform spawner | RMB remove"),
  inventory_image = "colour_jump_editor.png",
  groups = {not_in_creative_inventory = 1},
  on_drop = function() end,

  on_use = function(itemstack, user, pointed_thing)
    local mod         = user:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = user:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)

    local platforms = arena.platforms
    local platforms_amount = #arena.platforms
    local p_name = user:get_player_name()

    if platforms_amount >= 9 then
      arena_lib.print_error(p_name, S("There cannot be more than 9 platforms!"))
      return end

    local data = PLATFORMS_DATA[#platforms + 1]
    local platform = {pos = vector.floor(user:get_pos()), node = data.node, id = data.col, hexColor = data.hex}

    table.insert(platforms, platform)
    arena_lib.change_arena_property(user:get_player_name(), mod, arena_name, "platforms", platforms)
    show_waypoints(p_name, arena)
  end,

  on_secondary_use = function(itemstack, user, pointed_thing)
    local mod         = user:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = user:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)

    local platforms_amnt = #arena.platforms

    if platforms_amnt == 0 then return end

    local p_name = user:get_player_name()

    arena.platforms[platforms_amnt] = nil
    arena_lib.change_arena_property(p_name, mod, arena_name, "platforms", arena.platforms)
    show_waypoints(p_name, arena)
  end,

  on_place = function(itemstack, placer, pointed_thing)
    local mod         = placer:get_meta():get_string("arena_lib_editor.mod")
    local arena_name  = placer:get_meta():get_string("arena_lib_editor.arena")
    local _, arena    = arena_lib.get_arena_by_name(mod, arena_name)

    local platforms_amnt = #arena.platforms

    if platforms_amnt == 0 then return end

    local p_name = placer:get_player_name()

    arena.platforms[platforms_amnt] = nil
    arena_lib.change_arena_property(p_name, mod, arena_name, "platforms", arena.platforms)
    show_waypoints(p_name, arena)
  end
})





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function show_waypoints(p_name, arena)
  -- se sto aggiornando, devo prima rimuovere i vecchi
  if waypoints[p_name] then
    remove_waypoints(p_name)
  end

  local player = core.get_player_by_name(p_name)
  waypoints[p_name] = {}

  core.after(0.1, function()
    for id, data in ipairs(arena.platforms) do
      local HUD_ID = player:hud_add({
        type = "waypoint",
        name = S("Platform #@1", id),
        precision = 0,
        world_pos = data.pos,
      })

      table.insert(waypoints[p_name], HUD_ID)
    end
  end)
end



function remove_waypoints(p_name, arena)
  local player = core.get_player_by_name(p_name)
  -- potrebbe essersi disconnesso. Evito di computare in caso
  if player then
    for _, waypoint_ID in pairs(waypoints[p_name]) do
      player:hud_remove(waypoint_ID)
    end
  end

  waypoints[p_name] = nil
end
