local S = core.get_translator("colour_jump")



arena_lib.on_load("colour_jump", function(arena)
    arena.timer_current = arena.timer_initial_duration
    arena.waiting_time_current = arena.initial_waiting_time

    for _, data in pairs(arena.platforms) do
        colour_jump.set_platform(data)
    end

    for pl_name, _ in pairs(arena.players) do
        core.chat_send_player(pl_name, S("The minigame will start in a few seconds!"))
        core.chat_send_player(pl_name, S("To win, you have to be the last one standing! Reach the correct platform when it will be show on your screen...GOOD LUCK!"))
    end

    core.after(8, function()
        if not arena.in_game then return end

        arena.curr_platforms_data = table.copy(arena.platforms)
        colour_jump.start_round(arena)
    end)
end)