local S = core.get_translator("colour_jump")

local function contains() end
local function set_platform() end
local function set_platform_air() end
local function spawn_platforms() end



-- non esporre (per on_load.lua)
function colour_jump.start_round(arena)
    if arena.in_celebration or not arena.in_game then return end

    arena.rounds_counter = arena.rounds_counter + 1
    spawn_platforms(arena)

    arena.timer_current = math.max(arena.timer_min_duration, arena.timer_current - arena.timer_decrease_value)
    arena.waiting_time_current = math.max(arena.waiting_time_min_duration, arena.waiting_time_current - arena.waiting_time_decrease_value)
    arena.seconds_left = arena.timer_current

    local right_platform_id = math.random(1, #arena.platforms)

    for i, props in ipairs(arena.curr_platforms_data) do
        if i == right_platform_id then
            arena_lib.HUD_send_msg_all("title", arena, props.id, nil, nil, tonumber(props.hexColor))
        end
    end

    core.after(arena.timer_current, function()
        for i, props in ipairs(arena.curr_platforms_data) do
            if i ~= right_platform_id then
                set_platform_air(props.pos)
            end
        end

        core.after(arena.waiting_time_current, function()
            colour_jump.start_round(arena)
        end)
    end)
end



-- non esporre (per on_load.lua)
function colour_jump.set_platform(platform)
    local poss = {}
    for i = -1,1 do
        for k = -1,1 do
            local pos = platform.pos
            table.insert(poss, vector.new(pos.x-i, pos.y, pos.z-k))
        end
    end
    core.bulk_set_node(poss, {name=platform.node})
end



function set_platform_air(pos)
    local poss = {}
    for i = -1,1 do
        for k = -1,1 do
            table.insert(poss, vector.new(pos.x-i, pos.y, pos.z-k))
        end
    end
    core.bulk_set_node(poss, {name="air"})
end



function spawn_platforms(arena)
    local platforms_copy = table.copy(arena.platforms)

    local platforms_amount = #arena.platforms

    arena.curr_platforms_data = {}
    local new_data = {}
    local taken_numbers = {}
    local platform_number = math.random(1, platforms_amount)

    for i = 1, platforms_amount do
        -- cerca numero disponibile
        while (contains(taken_numbers, platform_number)) do
            platform_number = math.random(1, platforms_amount)
        end

        new_data.pos = platforms_copy[i].pos
        new_data.id = platforms_copy[platform_number].id
        new_data.node = platforms_copy[platform_number].node
        new_data.hexColor = platforms_copy[platform_number].hexColor
        colour_jump.set_platform(new_data)

        table.insert(taken_numbers, platform_number)
        table.insert(arena.curr_platforms_data, table.copy(new_data))
    end

    -- TODO: credo qui mescolasse le posizioni, ma col nuovo sistema non dovrebbe servire
    --[[for id, data in pairs(arena.platforms) do
        if id == new_data.id then
            data = new_data
        end
    end]]
end



function contains(table, val)
    for i=1,#table do
       if table[i] == val then
          return true
       end
    end
    return false
end