local S = core.get_translator("colour_jump")

local function print_timer() end



arena_lib.on_time_tick("colour_jump", function(arena)
    local stringOfRoundHUD = S('Lap: @1', arena.rounds_counter)
    local countPeopleFallen = 0

    for pl_name in pairs(arena.players) do
        local player = core.get_player_by_name(pl_name)
        if player:get_pos().y < arena.y then
                countPeopleFallen = countPeopleFallen + 1
        end
    end

    if (countPeopleFallen == arena.players_amount) and arena.players_amount > 1 then
        arena_lib.HUD_send_msg_all("title", arena, S('All the players fallen down! Nobody won'), 3, nil, "0xB6D53C")
        for pl_name in pairs(arena.players) do
                local player = core.get_player_by_name(pl_name)
                if colour_jump.HUD[pl_name] then
                        player:hud_remove(colour_jump.HUD[pl_name].scores)
                        player:hud_remove(colour_jump.HUD_BACKGROUND[pl_name].background)
                        colour_jump.HUD[pl_name] = nil
                        arena_lib.remove_player_from_arena( pl_name , 1 )
                end
        end
        -- arena_lib.force_arena_ending('colour_jump', arena, 'ColourJump')
    else
        -- TODO: move HUD into a separate file
        for pl_name in pairs(arena.players) do
            local player = core.get_player_by_name(pl_name)
            if not arena.in_celebration then
                if not colour_jump.HUD[pl_name] then
                    local new_hud_image = {}
                    new_hud_image.background = player:hud_add({
                    hud_elem_type = "image",
                    position  = {x = 1, y = 0},
                    offset = {x = -179, y = 32},
                    name = "colour_jump_background",
                    text = "HUD_colour_jump_round_counter.png",
                    alignment = { x = 1.0},
                    scale     = { x = 1.15, y = 1.15},
                    z_index = 100
                    })
                    colour_jump.HUD_BACKGROUND[pl_name] = new_hud_image

                    local new_hud = {}
                    new_hud.scores = player:hud_add({
                    hud_elem_type = "text",
                    position  = {x = 1, y = 0},
                    offset = {x = -155, y = 32},
                    alignment = {x = 1.0},
                    scale = {x = 2, y = 2},
                    name = "colour_jump_highscores",
                    text = S('Lap: @1', arena.rounds_counter),
                    z_index = 100,
                    number    = "0xFFFFFF"
                    })
                    colour_jump.HUD[pl_name] = new_hud

                else
                    local idText = colour_jump.HUD[pl_name].scores
                    player:hud_change(idText, "text", stringOfRoundHUD)
                    local idBackground = colour_jump.HUD_BACKGROUND[pl_name].background
                    player:hud_change(idBackground, "text", "HUD_colour_jump_round_counter.png")
                end
            end

            if player:get_pos().y < arena.y -4 then
                -- reset players pos if they fall down before the first colour appears
                -- (but don't if they're dead, e.g. melt in lava, so they will be
                -- eliminated the second right after)
                if arena.current_time <= arena.timer_initial_duration and player:get_hp() > 0 then
                    player:set_pos(arena_lib.get_random_spawner(arena, nil, true).pos)
                else
                    if colour_jump.HUD[pl_name] then
                        player:hud_remove(colour_jump.HUD[pl_name].scores)
                        player:hud_remove(colour_jump.HUD_BACKGROUND[pl_name].background)
                        colour_jump.HUD[pl_name] = nil
                    end

                    arena_lib.remove_player_from_arena( pl_name , 1 )
                    return
                end
            end
        end
    end
end)



local dtime_precision = 0.1
local dtimer = 0

core.register_globalstep(function(dtime)
    -- Reduce the amount of function calls
    dtimer = dtimer + dtime
    if dtimer < dtime_precision then
        return
    end

    for _, ar in pairs(arena_lib.mods["colour_jump"].arenas) do
        if ar.in_game then
            ar.seconds_left = ar.seconds_left - dtimer
            print_timer(ar)
        end
    end
    dtimer = 0
end)





----------------------------------------------
---------------FUNZIONI LOCALI----------------
----------------------------------------------

function print_timer(arena)
    local time = arena.seconds_left
    local round = arena.rounds_counter
    if round ~= 0 and time > 0 then
        local time_flat = math.ceil(time)
        if arena.last_hud_seconds ~= time_flat then
            arena_lib.HUD_send_msg_all("hotbar", arena, S('The platforms disappear in: @1 SECS!', time_flat), 1.5, nil, 0xFFFFFF)
            arena.last_hud_seconds = time_flat
        end
    else
        if arena.last_hud_seconds ~= -1 then
            arena_lib.HUD_hide("hotbar", arena)
            arena.last_hud_seconds = -1
        end
    end
end