techage.register_node({'asrs:controller'}, {
   on_inv_request = function(pos, in_dir, access_type)
      local meta = minetest.get_meta(pos)
      return meta:get_inventory(), 'storage'
   end,
   on_pull_item = function(pos, in_dir, num)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
      return techage.get_items(pos, inv, 'storage', num)
   end,
   on_push_item = function(pos, in_dir, stack)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
      return techage.put_items(inv, 'storage', stack)
   end,
   on_unpull_item = function(pos, in_dir, stack)
      local meta = minetest.get_meta(pos)
      local inv = meta:get_inventory()
      return techage.put_items(inv, 'storage', stack)
   end,
})
