function asrs.create_id(player_name, pos)
   local i = 1
   local system_id = player_name..'_'..i
   while asrs.data[system_id] do
      i = i + 1
      system_id = player_name..'_'..i
   end
   local new_data = {}
   new_data.inv_pos = pos
   new_data.max_inv = 0
   new_data.name = player_name
   new_data.nodes = 0
   asrs.data[system_id] = new_data
   return system_id
end

function asrs.update_inventory(pos)
   local meta = core.get_meta(pos)
   local sys_id = meta:get_string('system_id')
   local sys_data = asrs.data[sys_id]
   if sys_data then
      local sys_inv_max = sys_data.max_inv
      local inv = meta:get_inventory()
      inv:set_size('storage', sys_inv_max)
   end
end

function asrs.count_inventory(pos)
   local meta = core.get_meta(pos)
   local inv = meta:get_inventory()
   local inv_list = inv:get_list('storage')
   local count = 0
   local size = inv:get_size('storage')
   for i = 1, size do
      local stack = inv_list[i]
      local empty = stack:is_empty()
      if not empty then
         count = count + 1
      end
   end
   return count
end

function asrs.sort_inventory(pos)  -- Mostly copied from the Technic_chests mod.
   local meta = core.get_meta(pos)
   local inv = meta:get_inventory()
   local inv_list = inv:get_list('storage')
   local unique_items = {}
   if inv_list then
      local items = {}
      for _,stack in pairs(inv_list) do
         if not stack:is_empty() then
            local name = stack:get_name()
            local wear = stack:get_wear()
            local meta = stack:get_meta():get_string('')
            local count = stack:get_count()
            local def = core.registered_items[name]
            local key = string.format("%s %05d %s", name, wear, meta)
            if not items[key] then
               items[key] = {
                  stacks = {stack},
                  wear = wear,
                  count = count,
                  key = key,
               }
            else
               items[key].count = items[key].count + count
               table.insert(items[key].stacks, stack)
            end
         end
      end
      for k,v in pairs(items) do
         table.insert(unique_items, v)
      end
      local function padnum(value)
         local dec, n = string.match(value, "(%.?)0*(.+)")
         return #dec > 0 and ("%.12f"):format(value) or ("%s%03d%s"):format(dec, #n, n)
      end
      table.sort(unique_items, function(a, b)
         local sort_a = ("%s%3d"):format(tostring(a.key):gsub("%.?%d+", padnum), #b.key)
         local sort_b = ("%s%3d"):format(tostring(b.key):gsub("%.?%d+", padnum), #a.key)
         return sort_a < sort_b
      end)
   else
      -- Item
      table.sort(unique_items, function(a, b)
         return a.key < b.key
      end)
   end
   inv:set_list('storage', {})
   for _,item in ipairs(unique_items) do
      for _,stack in ipairs(item.stacks) do
         inv:add_item('storage', stack)
      end
   end
end

function asrs.connected_nodes(pos, node_name)
   local positions = {
      {x=pos.x+1, y=pos.y,   z=pos.z},
      {x=pos.x-1, y=pos.y,   z=pos.z},
      {x=pos.x,   y=pos.y+1, z=pos.z},
      {x=pos.x,   y=pos.y-1, z=pos.z},
      {x=pos.x,   y=pos.y,   z=pos.z+1},
      {x=pos.x,   y=pos.y,   z=pos.z-1},
   }
   local found_node = false
   local other_pos
   for _, loc in ipairs(positions) do
      local name = core.get_node(loc).name
      if string.find(node_name, name) then
         other_pos = loc
         found_node = true
         break
      end
   end
   return found_node, other_pos
end


fdir_table = {
   {  1,  0 },
   {  0, -1 },
   { -1,  0 },
   {  0,  1 },
   {  1,  0 },
   {  0, -1 },
   { -1,  0 },
   {  0,  1 },
}

function asrs.space_to_place(pos)
   local node = core.get_node(pos)
   local fdir = node.param2 % 32
   local pos2 = {x = pos.x + fdir_table[fdir+1][1], y=pos.y, z = pos.z + fdir_table[fdir+1][2]}
   local pos3 = {x = pos2.x, y = pos2.y+1, z = pos2.z}
   local pos4 = {x = pos.x, y = pos.y+1, z = pos.z}
   local node2 = core.get_node(pos2) -- Node to the right
   local node3 = core.get_node(pos3) -- Node above to the right
   local node4 = core.get_node(pos4) -- Node above
   local node2def = core.registered_nodes[node2.name] or nil
   local node3def = core.registered_nodes[node3.name] or nil
   local node4def = core.registered_nodes[node4.name] or nil
   if not node2def.buildable_to or not node3def.buildable_to or not node4def.buildable_to then
      return false
   else
      core.after(1, function()
         core.set_node(pos2,{name = 'asrs:blank'})
         core.set_node(pos3,{name = 'asrs:blank'})
         core.set_node(pos4,{name = 'asrs:connection_point'})
      end)
      return true
   end
end

function asrs.remove_side_node(pos, oldnode)
   local fdir = oldnode.param2 % 32
   local pos2 = {x = pos.x + fdir_table[fdir+1][1], y=pos.y, z = pos.z + fdir_table[fdir+1][2]}
   local pos3 = {x = pos2.x, y = pos2.y+1, z = pos2.z}
   local pos4 = {x = pos.x, y = pos.y+1, z = pos.z}
   core.remove_node(pos2)
   core.remove_node(pos3)
   core.remove_node(pos4)
end

function asrs.load()
   local file = io.open(core.get_worldpath() .. '/asrs_systems', 'r')
   if file then
      asrs.data = core.deserialize(file:read('*a'))
      file:close()
   else
      asrs.data = {}
   end
end

function asrs.save()
   local file = io.open(core.get_worldpath() .. '/asrs_systems', 'w')
   file:write(core.serialize(asrs.data))
   file:close()
end
