local function base()
   local resources = kobo.goblins
   local formspec =
      'formspec_version[7]'..
      'size[12,8]'..
      'background[-1,-1;14,10;lobby_button_bg.png]'..
      'label[4.5,1;This is a Goblin base.]'..
      'label[1,1;Lumber: '..resources.lumber..']'..
      'label[1,1.5;Food: '..resources.food..']'..
      'label[1,2;Stone: '..resources.stone..']'..
      'label[1,2.5;Metal: '..resources.metal..']'..
      'label[1,3;XP: '..resources.xp..']'..
      'label[1,3.5;Wave: '..resources.wave..']'..
      'button[4,5;3,1;rogue;Spawn Rogue]'..
      'button_exit[4,4;4,1;exit;Okay]'
   return formspec
end

local base_box = {
   type = 'fixed',
   fixed = {{-.55, -.5, -.55, .55, -.45, .55}}
   }

core.register_node('kobo:goblin_base', {
   description = 'Goblin Base',
   drawtype = 'mesh',
   mesh = 'kobo_goblin_base.obj',
   tiles = {'kobo_goblin_base.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = base_box,
   collision_box = base_box,
   groups = {goblin=1},
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      if core.check_player_privs(clicker, {server = true}) then
         local resources = kobo.goblins
         local player_name = clicker:get_player_name()
         core.show_formspec(player_name, 'kobo:goblin_base', base())
         kobo.player_pos[player_name] = pos
      end
   end,
   on_timer = function(pos)
      local timer = core.get_node_timer(pos)
      local resources = kobo.goblins
      if resources.food >= 25 and resources.lumber >= 5 then
         --spawn in a goblin and add to goblin XP
         local home_pos = vector.add(pos, {x=0, y=1, z=0})
         local goblin_scout = minetest.add_entity(pos, 'kobo:goblin_scout')
         local goblin_scout_entity = goblin_scout:get_luaentity()
         goblin_scout_entity.state = 'idle'
         goblin_scout_entity.inv = 0
         goblin_scout_entity.home = home_pos
         goblin_scout_entity.health = 25
         resources.xp = resources.xp + 1
         resources.wave = resources.wave + 1
         resources.food = resources.food - 25
         resources.lumber = resources.lumber - 5
      end
      if resources.wave % 9 == 0 then --Every nth goblins send a wave.
         local count = resources.wave / 9
         for i = 1, count do
            local goblin_rogue = minetest.add_entity(pos, 'kobo:goblin_rogue')
            local goblin_rogue_entity = goblin_rogue:get_luaentity()
            goblin_rogue_entity.state = 'idle'
            goblin_rogue_entity.last_job = pos
            goblin_rogue_entity.health = 40
         end
      end
      timer:start(60)
   end,
})


core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:goblin_base' then
      if fields.rogue then
         local name = player:get_player_name()
         local pos = kobo.player_pos[name]
         local goblin_rogue = minetest.add_entity(pos, 'kobo:goblin_rogue')
         local goblin_rogue_entity = goblin_rogue:get_luaentity()
         goblin_rogue_entity.state = 'idle'
         goblin_rogue_entity.last_job = pos
         goblin_rogue_entity.health = 40
      end
   end
end)
core.register_decoration({
      deco_type = 'simple',
      place_on = {'kobo:dirth'},
      sidelen = 16,
      fill_ratio = 0.00005,
      y_min = -1,
      y_max = 2,
      decoration = 'kobo:goblin_base',
      param2 = 0,
      param2_max = 3,
      biomes = {'wasteland'},
      spawn_by = 'kobo:dirth',
      num_spawn_by = 8
})

core.register_lbm({
   label = 'Start Goblin timer',
   name = 'kobo:goblin',
   nodenames = {'kobo:goblin_base'},
   run_at_every_load = true,
   action = function(pos, node)
      local timer = core.get_node_timer(pos)
      timer:start(60)
   end
})

core.register_abm({ --Random Goblins that run around and cause mischief.
   label = 'Rogue Goblin Spawning',
   name = 'kobo:goblin_spawn',
   nodenames = {'kobo:dirth'},
   interval = 300,
   chance = 250,
   action = function(pos)
      local spawn_pos = vector.add(pos, {x=0, y=1, z=0})
      if core.get_node(spawn_pos).name == 'air' then
         if core.get_node_light(spawn_pos) < 5 then
            local goblin_rogue = minetest.add_entity(spawn_pos, 'kobo:goblin_rogue')
            local goblin_rogue_entity = goblin_rogue:get_luaentity()
            goblin_rogue_entity.state = 'idle'
            goblin_rogue_entity.last_job = spawn_pos
            goblin_rogue_entity.health = 40
         end
      end
   end
})
