core.register_entity('kobo:goblin_tombstone', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'kobo_tombstone.obj',
      visual_size = {x=10, y=10},
      textures = {'kobo_tombstone.png'},
      physical = false,
      collisionbox = {-.125, -.5, -.125, .125, -.25, .125},
   },

   on_activate = function(self, staticdata, dtime_s)
      local data = core.deserialize(staticdata)
      if data then
         self.node_timer = data.node_timer
      end
   end,

   get_staticdata = function(self)
      local data = {}
      data.node_timer = self.node_timer
      return core.serialize(data)
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 60 then
         self.object:remove()
      end
   end,

   on_punch = function(self, puncher)
      self.object:remove()
   end,

--[[   on_rightclick = function(self, clicker)
      local player_name = clicker:get_player_name()
      core.show_formspec(player_name, 'kobo:goblin_debug', goblin_debug(self))
   end,
]]
})
