kobo = {}
kobo.player_pos = {} --Needed to store POS data for when players interact with formspecs.
kobo.building = {} --This stores what building a player is viewing in inventory so they can buy it.
kobo.hud = {}
kobo.building_inv =
   'formspec_version[7]'..
   'size[11,5]'..
   'position[1,1]'..
   'anchor[1,1]'..
   'bgcolor[#000000;neither]'..
   'background[-1,-1;12,6;kobo_building_bg.png;true]'..
   'style_type[textarea;textcolor=black;font_size=+10]'..
   'style_type[label;textcolor=black]'..
   'button[3.25,3.75;3,1;repair;Repair]'..
   'button[7.75,3.75;3,1;remove;Remove]'..
   'tooltip[repair;Summon craftsman to repair building;black;white]'..
   'tooltip[remove;Remove building, adds some resources back to inventory;black;white]'..
   'label[0,3.5;Health]'..
   'image[0,3.75;3,.25;kobo_graph_bg.png]'
   --The foreground image needs to be overlaid in the node formspec. Not all nodes have inventory, so that needs to be placed in the per-node formspec code.
   --'image[0,3.75;1.5,.25;kobo_health_fg.png]'..
   --'label[0,4.25;Inventory]'..
   --'image[0,4.5;3,.25;kobo_graph_bg.png]'
   --'image[0,4.5;3,.25;kobo_inv_fg.png]'

kobo.resource_inv =
   'formspec_version[7]'..
   'size[11,5]'..
   'position[1,1]'..
   'anchor[1,1]'..
   'bgcolor[#000000;neither]'..
   'background[-1,-1;12,6;kobo_building_bg.png;true]'..
   'style_type[textarea;textcolor=black;font_size=+10]'..
   'style_type[label;textcolor=black]'..
   'button[7.75,3.75;3,1;remove;Remove]'..
   'label[0,4.25;Inventory]'..
   'image[0,4.5;3,.25;kobo_graph_bg.png]'
   --'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'

kobo.unit_inv =
   'formspec_version[7]'..
   'size[11,5]'..
   'position[1,1]'..
   'anchor[1,1]'..
   'bgcolor[#000000;neither]'..
   'background[-1,-1;12,6;kobo_building_bg.png;true]'..
   'style_type[textarea;textcolor=black;font_size=+10]'..
   'style_type[label;textcolor=black]'..
   'label[0,4.25;Inventory]'..
   'image[0,4.5;3,.25;kobo_graph_bg.png]'
   --'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'

local modpath = core.get_modpath('kobo')

--Save and load data
dofile(modpath..'/file_functions.lua')
kobo.load()
core.register_on_shutdown(kobo.save)

--Shared functions
dofile(modpath..'/functions.lua')


--Player Inventory screens
dofile(modpath..'/inv_pages.lua')

--Player Buildings
dofile(modpath..'/base.lua')    --The town center, core, etc.
dofile(modpath..'/logging.lua') --Logging camps
dofile(modpath..'/walls.lua') --helpful for keeping goblins out.
dofile(modpath..'/towers.lua') --Can't have a tower defense game without towers
dofile(modpath..'/farm.lua')
dofile(modpath..'/storage.lua')

--Goblin Buildings
dofile(modpath..'/goblin_base.lua')
dofile(modpath..'/goblin_tombstone.lua')

--Player Units
dofile(modpath..'/foragers.lua')
dofile(modpath..'/lumberjacks.lua')
dofile(modpath..'/miners.lua')
dofile(modpath..'/couriers.lua')

--Goblin Units
dofile(modpath..'/goblin_scouts.lua')
dofile(modpath..'/goblin_rogues.lua')

--Resources
dofile(modpath..'/food_bushes.lua')
dofile(modpath..'/lumber.lua')
dofile(modpath..'/stone.lua')
dofile(modpath..'/metal.lua')

--Misc
dofile(modpath..'/chat_commands.lua')
dofile(modpath..'/hud.lua')
dofile(modpath..'/player.lua')

--Mapgen and map blocks
dofile(modpath..'/nodes.lua')
dofile(modpath..'/mapgen.lua')
