core.register_item(':', {
   type = 'none',
   wield_image = 'wieldhand.png',
   wield_scale = {x=1,y=1,z=2.5},
   range = 15,
   tool_capabilities = {
   full_punch_interval = 0.9,
   max_drop_level = 0,
   groupcaps = {
      oddly_breakable_by_hand = {times={[1]=3.50,[2]=2.00,[3]=0.70}, uses=0}
   },
   damage_groups = {fleshy=1},
}
})

core.register_on_newplayer(function(player)
   local player_inv = player:get_inventory()
   local player_name = player:get_player_name()
   local resources = {}
   player_inv:add_item('main', {name='kobo:base'})
   resources.food = 100
   resources.lumber = 100
   resources.stone = 10
   resources.metal = 10
   resources.xp = 0
   resources.research = 100
   kobo.resources[player_name] = resources
end)

core.register_on_joinplayer(function(player)
   player:set_properties({
      eye_height = 5.5,
      collisionbox = {-0.3, 0.0, -0.3, 0.3, 0.75, 0.3},
      stepheight = 1.01,
   })
   local player_inv = player:get_inventory()
   player_inv:set_size('hand', 1)
   player_inv:set_size('main', 8)
   core.chat_send_player(player:get_player_name(), 'Turn on the minimap. Square mode recommended.')
end)
