local function bush_overview(pos, food)
   local formspec =
   kobo.resource_inv..
   'textarea[3.25,0;7.5,1;;;Berry Bush]'..
   'image[0,0;3,3;kobo_bush_snap.png]'

   if food then
      local meta = core.get_meta(pos)
      local remaining = meta:get_int('remaining')
      if remaining == 0 then remaining = 100 end
      local scale = (remaining/100) * 3
      formspec = formspec..
      'textarea[3.25,.75;7.5,2.25;;;Harvest berries to collect food.\n'..
      'These bushes have '..remaining..' food remaining.]'..
      'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   else
      local timer = core.get_node_timer(pos)
      local remaining = math.ceil((timer:get_timeout()- timer:get_elapsed())/60)
      formspec = formspec..
      'textarea[3.25,.75;7.5,2.25;;;Harvest berries to collect food.\n'..
      'Berries grow back in '..remaining..' minute.]'
   end

   return formspec
end

local bush_box = {
   type = 'fixed',
   fixed = {{-.45, -.5, -.45, .45, -.1, .45}}
   }

core.register_node('kobo:bush_food', { --This has food
   description = 'Food Bush',
   drawtype = 'mesh',
   mesh = 'kobo_bush.obj',
   tiles = {'kobo_bush_food.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {food=2},
   selection_box = bush_box,
   collision_box = bush_box,
   _initial_count = 100,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      kobo.player_pos[player_name] = pos
      core.show_formspec(player_name, 'kobo:bush', bush_overview(pos, true))
   end,
   on_punch = function(pos, node, puncher, pointed_thing)
      local meta = core.get_meta(pos)
      local remaining = meta:get_int('remaining')
      if remaining == 0 then -- Tree hasn't been punched yet. Add to player inventory.
         if kobo.add_player_inventory_hand(puncher, 'kobo:food') then
            meta:set_int('remaining', 99)
         end
      elseif remaining == 1 then --Last bit of wood, add to player inventory, and remove the node.
         if kobo.add_player_inventory_hand(puncher, 'kobo:food') then
            core.swap_node(pos, {name = 'kobo:bush', param2 = node.param2})
            local timer = core.get_node_timer(pos)
            timer:start(600)
         end
      else --Add inventory to player, cap at some level.
         if kobo.add_player_inventory_hand(puncher, 'kobo:food') then
            meta:set_int('remaining', remaining - 1)
         end
      end
   end,
})

core.register_node('kobo:bush', { --This has NO food
   description = 'Bush',
   drawtype = 'mesh',
   mesh = 'kobo_bush.obj',
   tiles = {'kobo_bush.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = bush_box,
   collision_box = bush_box,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      kobo.player_pos[player_name] = pos
      core.show_formspec(player_name, 'kobo:bush', bush_overview(pos, false))
   end,
   on_punch = function(pos, node, puncher, pointed_thing)
      core.chat_send_player(puncher:get_player_name(), 'These bushes currently have no food.')
   end,
   on_timer = function(pos)
      local node = core.get_node(pos)
      core.set_node(pos, {name = 'kobo:bush_food', param2 = node.param2})
   end,
})

core.register_craftitem('kobo:food', {
   description = 'Food',
   inventory_image = 'kobo_food.png',
   stack_max = 25,
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'kobo:grass'},
      sidelen = 16,
      noise_params = {
         offset = .01,
         scale = 0.05,
         spread = {x = 300, y = 20, z = 300},
         seed = 684132,
         octaves = 4,
         persist = .5,
         lacunarity = 2,
         flags = 'ease'
      },
      y_min = -1,
      y_max = 2,
      decoration = 'kobo:bush_food',
      param2 = 0,
      param2_max = 3,
      biomes = {'grassland'},
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:bush' then
      if fields.remove then
         local name = player:get_player_name()
         local pos = kobo.player_pos[name]
         core.remove_node(pos)
         core.close_formspec(name, 'kobo:bush')
      end
   end
end)
