function kobo.place_lights(pos)
   local above_pos = vector.add(pos, {x=0, y=2, z=0})
   local N_pos = vector.add(pos, {x=4, y=2, z=4})
   local S_pos = vector.add(pos, {x=-4, y=2, z=-4})
   local E_pos = vector.add(pos, {x=4, y=2, z=-4})
   local W_pos = vector.add(pos, {x=-4, y=2, z=4})
   core.set_node(above_pos, {name = 'kobo:light'})
   core.set_node(N_pos, {name = 'kobo:light_2'})
   core.set_node(S_pos, {name = 'kobo:light_2'})
   core.set_node(E_pos, {name = 'kobo:light_2'})
   core.set_node(W_pos, {name = 'kobo:light_2'})
end

function kobo.remove_lights(pos)
   local above_pos = vector.add(pos, {x=0, y=2, z=0})
   local N_pos = vector.add(pos, {x=4, y=2, z=4})
   local S_pos = vector.add(pos, {x=-4, y=2, z=-4})
   local E_pos = vector.add(pos, {x=4, y=2, z=-4})
   local W_pos = vector.add(pos, {x=-4, y=2, z=4})
   core.remove_node(above_pos)
   core.remove_node(N_pos)
   core.remove_node(S_pos)
   core.remove_node(E_pos)
   core.remove_node(W_pos)
end

function kobo.add_player_inventory_hand(player, material)
   local player_inv = player:get_inventory()
   if player_inv:room_for_item('hand', {name = material}) then
      player_inv:add_item('hand', material)
      return true
   else
      core.chat_send_player(player:get_player_name(), 'You can\'t take that now.')
      return false
   end
end

function kobo.add_player_inventory_main(player, material)
   local player_inv = player:get_inventory()
   if player_inv:room_for_item('main', {name = material}) then
      player_inv:add_item('main', material)
      return true
   else
      core.chat_send_player(player:get_player_name(), 'No empty inventory slots.')
      return false
   end
end
