local function tree_overview(pos)
   local meta = core.get_meta(pos)
   local remaining = meta:get_int('remaining')
   if remaining == 0 then remaining = 250 end
   local scale = (remaining/250) * 3
   local formspec =
   kobo.resource_inv..
   'textarea[3.25,0;7.5,1;;;Tree]'..
   'image[0,0;3,3;kobo_tree_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;Chop trees to collect lumber.\n'..
   'These trees have '..remaining..' lumber remaining.]'..
   'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   return formspec
end

local sel_box = {
   type = 'fixed',
   fixed = {{-.45, .0, -.45, .45, .5, .45}}
   }

local col_box = {
   type = 'fixed',
   fixed = {{-.45, -.5, -.45, .45, .125, .45}}
   }

core.register_node('kobo:tree', {
   description = 'Tree',
   drawtype = 'mesh',
   mesh = 'kobo_tree.obj',
   tiles = {'kobo_tree.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {lumber=1},
   selection_box = sel_box,
   collision_box = col_box,
   _initial_count = 250,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      kobo.player_pos[player_name] = pos
      core.show_formspec(player_name, 'kobo:tree', tree_overview(pos))
   end,
   on_punch = function(pos, node, puncher, pointed_thing)
      local meta = core.get_meta(pos)
      local remaining = meta:get_int('remaining')
      if remaining == 0 then -- Tree hasn't been punched yet. Add to player inventory.
         if kobo.add_player_inventory_hand(puncher, 'kobo:lumber') then
            meta:set_int('remaining', 249)
         end
      elseif remaining <= 1 then --Last bit of wood, add to player inventory, and remove the node.
         if kobo.add_player_inventory_hand(puncher, 'kobo:lumber') then
            core.remove_node(pos)
         end
      else --Add inventory to player, cap at some level.
         if kobo.add_player_inventory_hand(puncher, 'kobo:lumber') then
            meta:set_int('remaining', remaining - 1)
         end
      end
   end,
})

core.register_craftitem('kobo:lumber', {
   description = 'Lumber',
   inventory_image = 'kobo_lumber.png',
   stack_max = 25,
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'kobo:grass'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.05,
         spread = {x = 300, y = 20, z = 300},
         seed = 357452,
         octaves = 4,
         persist = .6
      },
      y_min = -1,
      y_max = 2,
      decoration = 'kobo:tree',
      param2 = 0,
      param2_max = 3,
      biomes = {'grassland'},
      spawn_by = 'kobo:grass',
      num_spawn_by = 8
})


core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:tree' then
      if fields.remove then
         local name = player:get_player_name()
         local pos = kobo.player_pos[name]
         core.remove_node(pos)
         core.close_formspec(name, 'kobo:tree')
      end
   end
end)
