local function lumberjack_overview(obj)
   local scale = (obj.inv/25) * 3
   local formspec =
   kobo.unit_inv..
   'textarea[3.25,0;7.5,1;;;Lumberjack]'..
   'image[0,0;3,3;kobo_lumberjack_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;Lumberjack state: '..obj.state..'.\n'..
   'Lumberjack inventory: '..obj.inv..' lumber.]'..
   'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   return formspec
end

core.register_entity('kobo:lumberjack', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'kobo_worker.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collide_with_objects = false,
      collisionbox = {-.125, -.5, -.125, .125, 0, .125},
      textures = {'kobo_lumberjack.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      local data = core.deserialize(staticdata)
      if data then
         self.node_timer = data.node_timer
         self.owner = data.owner
         self.home = data.home
         self.state = data.state
         self.path = data.path
         self.step = data.step
         self.inv = data.inv
         self.last_job = data.last_job
      end
   end,

   get_staticdata = function(self)
      local data ={}
      data.node_timer = self.node_timer
      data.owner = self.owner
      data.home = self.home
      data.state = self.state
      data.path = self.path
      data.step = self.step
      data.inv = self.inv
      data.last_job = self.last_job
      return core.serialize(data)
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         if self.state == 'idle' then --Find the lazybones some work.
            local last_job = self.last_job
            if not last_job then
               local self_pos = vector.add(self.object:get_pos(), {x=0, y=1, z=0})
               local trees = core.find_node_near(self_pos, 10, 'group:lumber')
               if trees then
                  --local pos1 = vector.add(trees, {x=-1, y=0, z=-1})
                  --local pos2 = vector.add(trees, {x=1, y=0, z=1})
                  --local chopping_spot = core.find_nodes_in_area(pos1, pos2, 'air')
                  --local spot = math.random(1, #chopping_spot)
                  local ran_x = math.random(1,10)/10
                  local ran_z = math.random(1,10)/10
                  local path = core.find_path(self_pos, vector.add(trees, {x=ran_x, y=1, z=ran_z}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  else --Make the unit wander around for a while.
                     self.state = 'idle'
                  end
               else
                  local buildings = core.find_node_near(self_pos, 10, 'group:storage')
                  if buildings then
                     --local destination = core.find_node_near(buildings, 1, 'air')
                     --if destination then
                        local ran_x = math.random(1,10)/10
                        local ran_z = math.random(1,10)/10
                        local path = core.find_path(self_pos, vector.add(buildings, {x=ran_x, y=1, z=ran_z}), 5, 1, 1)
                        if path then
                           self.path = path
                           self.step = 2
                           self.state = 'traveling'
                        end
                     else --Make the unit wander around for a while.
                        self.state = 'idle'
                     --end
                  end
               end
            else
               local tree = core.find_node_near(last_job, 1, 'group:lumber', true)
               if tree then
                  local self_pos = vector.add(self.object:get_pos(), {x=0, y=1, z=0})
                  --local pos1 = vector.add(tree, {x=-1, y=0, z=-1})
                  --local pos2 = vector.add(tree, {x=1, y=0, z=1})
                  --local chopping_spot = core.find_nodes_in_area(pos1, pos2, 'air')
                  --local spot = math.random(1, #chopping_spot)
                  local ran_x = math.random(1,10)/10
                  local ran_z = math.random(1,10)/10
                  local path = core.find_path(self_pos, vector.add(tree, {x=ran_x, y=1, z=ran_z}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 1
                     self.state = 'traveling'
                  end
               else --Make the unit wander around for a while.
                  self.last_job = nil
                  self.state = 'idle'
               end
            end
         elseif self.state == 'traveling' then
            if #self.path > (self.step - 1) then
               local pos = self.object:get_pos()
               local perhaps = vector.direction(pos, self.path[self.step])
               self.object:set_velocity({x = perhaps.x, y = 0, z = perhaps.z})
               self.step = self.step + 1
            else
               local self_pos = vector.round(self.object:get_pos())
               local tree = core.find_node_near(self_pos, 1, 'group:lumber', true)
               if tree then
                  self.object:set_velocity({x=0, y=0, z=0})
                  self.state = 'working'
                  self.last_job = tree
               elseif core.find_node_near(self_pos, 1, 'group:storage', true) then
                  local resources = kobo.resources[self.owner]
                  resources.lumber = resources.lumber + self.inv
                  self.inv = 0
                  local player = core.get_player_by_name(self.owner)
                  kobo.hud_refresh(player)
                  self.state = 'idle'
               else
                  self.state = 'idle'
               end
            end
         elseif self.state == 'working' then --Harvesting wood!!!
            local inventory_count = self.inv
            if inventory_count < 25 then
               self.inv = self.inv + 1
               local pos = self.last_job
               local node = core.get_node(pos)
               local meta = core.get_meta(pos)
               local remaining = meta:get_int('remaining')
               if remaining == 0 then
                  local def = minetest.registered_nodes[node.name]
                  remaining = def._initial_count
                  if remaining then
                     meta:set_int('remaining', remaining - 1)
                  end
               elseif remaining == 1 then
                  core.remove_node(pos)
                  self.state = 'idle'
               else
                  meta:set_int('remaining', remaining - 1)
               end
            else
               local ran_x = math.random(1,10)/10
               local ran_z = math.random(1,10)/10
               local self_pos = vector.add(self.object:get_pos(), {x=0, y=1, z=0})
               local storage_point = core.find_node_near(self_pos, 10, 'group:storage')
               if storage_point then
                  local path = core.find_path(self_pos, vector.add(storage_point, {x=ran_x, y=1, z=ran_z}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  end
               else --Make the unit wander around for a while.
                  local path = core.find_path(self_pos, vector.add(self.home, {x=ran_x, y=1, z=ran_z}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  end
               end
            end
         end
      elseif moveresults.collides then
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local node_pos = moveresults.collisions[1].node_pos
            local node = core.get_node(node_pos)
            if core.get_item_group(node.name, 'storage') > 0 then
               print 'bumped into a storage facilty'
               local resources = kobo.resources[self.owner]
               resources.lumber = resources.lumber + self.inv
               self.inv = 0
               self.state = 'idle'
            elseif core.get_item_group(node.name, 'lumber') > 0 then
               print 'bumped into a lumber source.'
               local node_pos = moveresults.collisions[1].node_pos
               local node = core.get_node(node_pos)
               local def = core.registered_nodes[node.name]
               local material = def._material
               self.object:set_velocity({x=0, y=0, z=0})
               self.last_job = node_pos
               self.state = 'working'
            end
         end
      end
   end,

   on_rightclick = function(self, clicker)
      local player_name = clicker:get_player_name()
      if self.owner == player_name or core.check_player_privs(clicker, {server = true}) then
         core.show_formspec(player_name, 'kobo:lumberjack_overview', lumberjack_overview(self))
      end
   end,

})
