core.register_alias('mapgen_stone', 'kobo:mapgen_stone')
core.register_alias('mapgen_water_source', 'kobo:water')

core.register_on_mapgen_init(function(mapgen_params)
   core.set_mapgen_setting('mg_flags', 'nocaves, nodungeons', true)
   core.set_mapgen_setting('mgflat_spflags', 'nolakes, hills, nocaverns', true)
   core.set_mapgen_setting('mgflat_ground_level', 1, true)
   core.set_noiseparams('mg_biome_np_heat',     {lacunarity = 2, octaves = 2, spread = {z = 100, x = 100, y = 100}, seed = 5349, offset = 50, flags = "defaults", scale = 50, persist = 0.5, persistence = 0.5})
   core.set_noiseparams('mg_biome_np_humidity', {lacunarity = 2, octaves = 2, spread = {z = 100, x = 100, y = 100}, seed = 6874, offset = 50, flags = "defaults", scale = 50, persist = 0.5, persistence = 0.5})
end)

core.register_biome({
   name = 'grassland',
   node_top = 'kobo:grass',
   depth_top = 4,
   node_filler = 'kobo:mapgen_stone',
   depth_filler = 4,
   y_max = 1,
   y_min = 0,
   heat_point = 50,
   humidity_point = 35,
})

core.register_biome({
   name = 'desert',
   node_top = 'kobo:sand',
   depth_top = 4,
   node_filler = 'kobo:sand',
   depth_filler = 4,
   y_max = 1,
   y_min = 0,
   heat_point = 90,
   humidity_point = 5,
})

core.register_biome({
   name = 'wasteland',
   node_top = 'kobo:dirth',
   depth_top = 4,
   node_filler = 'kobo:mapggen_stone',
   depth_filler = 4,
   y_max = 1,
   y_min = 0,
   heat_point = 20,
   humidity_point = 25,
})

core.register_biome({
   name = 'mountains',
   node_top = 'kobo:mountain_stone',
   depth_top = 4,
   node_filler = 'kobo:mountain_stone',
   depth_filler = 4,
   y_max = 150,
   y_min = 2,
   heat_point = 50,
   humidity_point = 50,
})
