local function repairman_overview(obj)
   local formspec =
   kobo.unit_inv..
   'textarea[3.25,0;7.5,1;;;repairman]'..
   'image[0,0;3,3;kobo_repairman_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;repairman state: '..obj.state..'.]'..
   'image[0,4.5;3,.25;kobo_inv_fg.png]'
   return formspec
end

core.register_entity('kobo:repairman', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'kobo_worker.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collide_with_objects = false,
      collisionbox = {-.125, -.5, -.125, .125, 0, .125},
      textures = {'kobo_repairman.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      local data = core.deserialize(staticdata)
      if data then
         self.node_timer = data.node_timer
         self.owner = data.owner
         self.home = data.home
         self.state = data.state
         self.path = data.path
         self.step = data.step
         self.last_job = data.last_job
      end
   end,

   get_staticdata = function(self)
      local data ={}
      data.node_timer = self.node_timer
      data.owner = self.owner
      data.home = self.home
      data.state = self.state
      data.path = self.path
      data.step = self.step
      data.last_job = self.last_job
      return core.serialize(data)
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         if self.state == 'idle' then --Find the lazybones some work.
            local self_pos = self.object:get_pos()
            local node = core.get_node(self_pos)
            local repair = core.find_node_near(self_pos, 10, 'kobo:repair')
            if repair then
               local def = core.registered_nodes[node.name]
               if def.walkable then
                  self_pos = vector.add(self_pos, {x=0, y=1, z=0})
               end
               local path = core.find_path(self_pos, repair, 5, 1, 1)
               if path then
                  self.path = path
                  self.step = 2
                  self.state = 'traveling'
               else --Make the unit wander around for a while.
                  self.state = 'idle'
               end
            else
               local buildings = core.find_node_near(self_pos, 10, 'group:storage')
               if buildings then
                  local def = core.registered_nodes[node.name]
                  if def.walkable then
                     self_pos = vector.add(self_pos, {x=0, y=1, z=0})
                  end
                  local path = core.find_path(self_pos, vector.add(buildings, {x=0, y=1, z=0}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  end
               else
                  self.state = 'idle'
               end
            end
         elseif self.state == 'traveling' then
            if #self.path > (self.step - 1) then
               local pos = self.object:get_pos()
               local perhaps = vector.direction(pos, self.path[self.step])
               self.object:set_velocity({x = perhaps.x, y = 0, z = perhaps.z})
               self.step = self.step + 1
            else
               local self_pos = vector.round(self.object:get_pos())
               local repair = core.find_node_near(self_pos, 1, 'kobo:repair', true)
               if repair then
                  self.object:set_velocity({x=0, y=0, z=0})
                  self.state = 'working'
                  self.last_job = repair
               else
                  self.state = 'idle'
               end
            end
         elseif self.state == 'working' then
            local node = core.get_node(self.last_job)
            if core.get_item_group(node.name, 'player_building') > 0 then
               local meta = core.get_meta(self.last_job)
               local health = meta:get_int('health')
               local def = core.registered_nodes[node.name]
               local max_health = def._health
               if health < max_health then
                  local resources = kobo.resources[self.owner]
                  if resources.metal >= 1 then
                     meta:set_int('health', math.min(health + 5, max_health))
                     resources.metal = resources.metal - 1
                     local player = core.get_player_by_name(self.owner)
                     kobo.hud_refresh(player)
                  end
               else
                  self.state = 'idle'
               end
            else
               local repair_pos = vector.add(self.last_job, {x=0, y=1, z=0})
               core.remove_node(self.last_job)
               self.state = 'idle'
            end
         end
      elseif moveresults.collides then
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local node_pos = moveresults.collisions[1].node_pos
            local node = core.get_node(node_pos)
            if core.get_item_group(node.name, 'player_building') > 0 then
               local meta = core.get_meta(node_pos)
               local health = meta:get_int('health')
               local def = core.registered_nodes[node.name]
               local max_health = def._health
               if health < max_health then
                  self.last_job = node_pos
                  self.state = 'working'
                  self.object:set_velocity({x=0, y=0, z=0})
               else
                  local repair_pos = vector.add(node_pos, {x=0, y=1, z=0})
                  core.remove_node(repair_pos)
               end
            end
         end
      end
   end,

   on_rightclick = function(self, clicker)
      local player_name = clicker:get_player_name()
      if self.owner == player_name or core.check_player_privs(clicker, {server = true}) then
         core.show_formspec(player_name, 'kobo:repairman_overview', repairman_overview(self))
      end
   end,

})
