local function logging_1_overview(pos)
   local meta = core.get_meta(pos)
   local inventory = meta:get_int('inventory')
   local pos1 = vector.add(pos, {x=-3, y=0, z=-3})
   local pos2 = vector.add(pos, {x=3, y=0, z=3})
   local trees = core.find_nodes_in_area(pos1, pos2, 'group:lumber')
   local health = meta:get_int('health')
   local hp_scale = (health/50) * 3
   local inv_scale = (inventory/50) * 3
   local formspec =
   kobo.building_inv..
   'textarea[3.25,0;7.5,1;;;Logging Camp (tier 1)]'..
   'image[0,0;3,3;kobo_logging_1_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;There are '..#trees..' tree(s) available to chop.]'..
   'image_button[3.25,2;1,1;kobo_evergreen_ico.png;add_trees;;true;false]'..
   'tooltip[add_trees;Plant trees (50 lumber, 25 stone);black;white]'..
   'image[0,3.75;'..hp_scale..',.25;kobo_health_fg.png]'..
   'label[0,4.25;Inventory]'..
   'image[0,4.5;3,.25;kobo_graph_bg.png]'..
   'image[0,4.5;'..inv_scale..',.25;kobo_inv_fg.png]'
   return formspec
end

local function logging_1_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:logging_1', logging_1_overview(pos))
      core.after(.25, function()
         logging_1_overview_wrapper(player, pos)
      end)
   end
end

local function logging_2_overview(pos)
   local meta = core.get_meta(pos)
   local inventory = meta:get_int('inventory')
   local pos1 = vector.add(pos, {x=-6, y=0, z=-6})
   local pos2 = vector.add(pos, {x=6, y=0, z=6})
   local trees = core.find_nodes_in_area(pos1, pos2, 'group:lumber')
   local health = meta:get_int('health')
   local hp_scale = (health/125) * 3
   local inv_scale = (inventory/100) * 3
   local formspec =
   kobo.building_inv..
   'textarea[3.25,0;7.5,1;;;Logging Camp (tier 2)]'..
   'image[0,0;3,3;kobo_logging_2_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;There are '..#trees..' tree(s) available to chop.]'..
   'image_button[3.25,2;1,1;kobo_evergreen_ico.png;add_trees;;true;false]'..
   'tooltip[add_trees;Plant trees (50 lumber, 25 stone);black;white]'..
   'image[0,3.75;'..hp_scale..',.25;kobo_health_fg.png]'..
   'label[0,4.25;Inventory]'..
   'image[0,4.5;3,.25;kobo_graph_bg.png]'..
   'image[0,4.5;'..inv_scale..',.25;kobo_inv_fg.png]'
   return formspec
end

local function logging_2_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:logging_2', logging_2_overview(pos))
      core.after(.25, function()
         logging_2_overview_wrapper(player, pos)
      end)
   end
end

local logging_1_box = {
   type = 'fixed',
   fixed = {{-.55, -.5, -.55, 1.55, -.375, 1.55}}
   }

local logging_2_box = {
   type = 'fixed',
   fixed = {{-.55, -.5, -.55, 1.55, -.375, 1.55}}
   }

local pathways = {
   { 0, -1},
   {-1,  0},
   { 0,  1},
   { 1,  0},
}

core.register_node('kobo:logging_1', {
   description = 'Logging Camp (tier 1)',
   drawtype = 'mesh',
   mesh = 'kobo_logging_1.obj',
   tiles = {'kobo_logging_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   selection_box = logging_1_box,
   collision_box = logging_1_box,
   groups = {collector=1, player_building=1},
   _snapshot = 'kobo_logging_1_snap.png',
   _cost = {50, 100, 25, 0},
   _health = 50,
   _max_inv = 50,
   _material = 'lumber',
   _long_desc = 'An automatic lumber harvester. You will need inventory transportation units to pick up lumber and transfer it to a storage facility.',
   after_place_node = function(pos, placer)
      local player_name = placer:get_player_name()
      if kobo.space_for_building(pos) then
         local pos_check = vector.subtract(pos, {x=0, y=1, z=0})
         local node_check = core.get_node(pos_check)
         if core.get_item_group(node_check.name, 'ground') > 0 then
            local meta = core.get_meta(pos)
            local timer = core.get_node_timer(pos)
            local resources = kobo.resources[player_name]
            meta:set_string('owner', player_name)
            meta:set_int('inventory', 0)
            meta:set_int('health', 50)
            kobo.place_lights(pos)
            timer:start(5)
            resources.xp = resources.xp + 1
            local node = core.get_node(pos)
            local fdir = node.param2 % 32
            local path1 = {x=pos.x + pathways[fdir+1][1], y=pos.y, z=pos.z + pathways[fdir+1][2]}
            local path2 = {x=pos.x + (2*(pathways[fdir+1][1])), y=pos.y, z=pos.z + (2*(pathways[fdir+1][2]))}
            core.set_node(path1,{name = 'kobo:empty'})
            core.set_node(path2,{name = 'kobo:empty'})
         else
            core.chat_send_player(player_name, 'You can\'t place this here.')
            core.remove_node(pos)
            return true
         end
      else
         core.chat_send_player(player_name, 'There is something in the way.')
         core.remove_node(pos)
         return true
      end
   end,
   after_destruct = function(pos, oldnode)
      kobo.remove_lights(pos)
      kobo.remove_building_spaces(pos, oldnode)
      local fdir = oldnode.param2 % 32
      local path1 = {x=pos.x + pathways[fdir+1][1], y=pos.y, z=pos.z + pathways[fdir+1][2]}
      local path2 = {x=pos.x + (2*(pathways[fdir+1][1])), y=pos.y, z=pos.z + (2*(pathways[fdir+1][2]))}
      core.remove_node(path1)
      core.remove_node(path2)
   end,
   on_timer = function(pos)
      local meta = core.get_meta(pos)
      local inventory = meta:get_int('inventory')
      local timer = core.get_node_timer(pos)
      if inventory <= 50 then
         local pos1 = vector.add(pos, {x=-3, y=0, z=-3})
         local pos2 = vector.add(pos, {x=3, y=0, z=3})
         local trees = core.find_nodes_in_area(pos1, pos2, 'group:lumber')
         if trees then
            meta:set_int('inventory', inventory + #trees)
            for i = 1, #trees do
               local tree_meta = core.get_meta(trees)
               local remaining = tree_meta:get_int('remaining')
               local meta = core.get_meta(pos)
               local inv = meta:get_inventory()
               if remaining == 0 then -- Tree hasn't been punched yet.
                  tree_meta:set_int('remaining', 250)
               elseif remaining <= 1 then --Last bit of wood, add to inventory, and remove the node.
                  core.remove_node(trees)
               else --Add inventory
                  tree_meta:set_int('remaining', remaining - 1)
               end
            end
         end
      end
      timer:start(5)
   end,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         logging_1_overview_wrapper(player_name, pos)
      end
   end,
})

core.register_node('kobo:logging_2', {
   description = 'Logging Camp (tier 2)',
   drawtype = 'mesh',
   mesh = 'kobo_logging_2.obj',
   tiles = {'kobo_logging_2.png'},
   inventory_image = 'kobo_logging_2_ico.png',
   wield_image = 'kobo_logging_2_ico.png',
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   selection_box = logging_2_box,
   collision_box = logging_2_box,
   groups = {collector=1, player_building=1},
   _snapshot = 'kobo_logging_2_snap.png',
   _cost = {50, 200, 50, 0},
   _health = 125,
   _max_inv = 100,
   _material = 'lumber',
   _long_desc = 'An automatic lumber harvester. You will need inventory transportation units to pick up lumber and transfer it to a storage facility.',
   after_place_node = function(pos, placer)
      local player_name = placer:get_player_name()
      if kobo.space_for_building(pos) then
         local pos_check = vector.subtract(pos, {x=0, y=1, z=0})
         local node_check = core.get_node(pos_check)
         if core.get_item_group(node_check.name, 'ground') > 0 then
            local meta = core.get_meta(pos)
            local timer = core.get_node_timer(pos)
            local resources = kobo.resources[player_name]
            meta:set_string('owner', player_name)
            meta:set_string('infotext', 'Logging Camp')
            meta:set_int('inventory', 0)
            meta:set_int('health', 125)
            kobo.place_lights(pos)
            timer:start(5)
            resources.xp = resources.xp + 1
            local node = core.get_node(pos)
            local fdir = node.param2 % 32
            local path1 = {x=pos.x + pathways[fdir+1][1], y=pos.y, z=pos.z + pathways[fdir+1][2]}
            local path2 = {x=pos.x + (2*(pathways[fdir+1][1])), y=pos.y, z=pos.z + (2*(pathways[fdir+1][2]))}
            core.set_node(path1,{name = 'kobo:empty'})
            core.set_node(path2,{name = 'kobo:empty'})
         else
            core.chat_send_player(player_name, 'You can\'t place this here.')
            core.remove_node(pos)
            return true
         end
      else
         core.chat_send_player(player_name, 'There is something in the way.')
         core.remove_node(pos)
         return true
      end
   end,
   after_destruct = function(pos, oldnode)
      kobo.remove_lights(pos)
      kobo.remove_building_spaces(pos, oldnode)
      kobo.remove_building_spaces(pos, oldnode)
      local fdir = oldnode.param2 % 32
      local path1 = {x=pos.x + pathways[fdir+1][1], y=pos.y, z=pos.z + pathways[fdir+1][2]}
      local path2 = {x=pos.x + (2*(pathways[fdir+1][1])), y=pos.y, z=pos.z + (2*(pathways[fdir+1][2]))}
      core.remove_node(path1)
      core.remove_node(path2)
   end,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.refresh[player_name] = true
         logging_2_overview_wrapper(player_name, pos)
         kobo.player_pos[player_name] = pos
      end
   end,
   on_timer = function(pos)
      local meta = core.get_meta(pos)
      local inventory = meta:get_int('inventory')
      local timer = core.get_node_timer(pos)
      if inventory < 100 then
         local pos1 = vector.add(pos, {x=-6, y=0, z=-6})
         local pos2 = vector.add(pos, {x=6, y=0, z=6})
         local trees = core.find_nodes_in_area(pos1, pos2, 'group:lumber')
         if trees then
            meta:set_int('inventory', inventory + #trees)
            for i = 1, #trees do
               local tree_meta = core.get_meta(trees)
               local remaining = tree_meta:get_int('remaining')
               local meta = core.get_meta(pos)
               local inv = meta:get_inventory()
               if remaining == 0 then -- Tree hasn't been punched yet.
                  tree_meta:set_int('remaining', 250)
               elseif remaining <= 1 then --Last bit of wood, add to inventory, and remove the node.
                  core.remove_node(trees)
               else --Add inventory
                  tree_meta:set_int('remaining', remaining - 1)
               end
            end
         end
      end
      timer:start(5)
   end,
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:logging_1' then
      local name = player:get_player_name()
      local pos = kobo.player_pos[name]
      if fields.add_trees then
         local resources = kobo.resources[name] or {}
         if resources.lumber >= 50 and resources.stone >= 25 then
            local pos1 = vector.add(pos, {x=-1, y=0, z=-1})
            local pos2 = vector.add(pos, {x=1, y=0, z=1})
            local open_space = core.find_nodes_in_area(pos1, pos2, 'air')
            if #open_space > 1 then
               local spot = math.random(1, #open_space)
               core.set_node(open_space[spot], {name = 'kobo:evergreen_1'})
               local timer = core.get_node_timer(open_space[spot])
               timer:start(300)
               resources.stone = resources.stone - 25
               resources.lumber = resources.lumber - 100
               kobo.hud_refresh(player)
            else
               pos1 = vector.add(pos, {x=-2, y=0, z=-2})
               pos2 = vector.add(pos, {x=2, y=0, z=2})
               open_space = core.find_nodes_in_area(pos1, pos2, 'air')
               if #open_space > 1 then
                  local spot = math.random(1, #open_space)
                  core.set_node(open_space[spot], {name = 'kobo:evergreen_1'})
                  local timer = core.get_node_timer(open_space[spot])
                  timer:start(300)
                  resources.stone = resources.stone - 25
                  resources.lumber = resources.lumber - 100
                  kobo.hud_refresh(player)
               end
            end
         else
            core.chat_send_player(name, 'You need more resources.')
         end
      elseif fields.remove then
         local resources = kobo.resources[name]
         core.remove_node(pos)
         resources.food = resources.food + 37
         resources.lumber = resources.lumber + 75
         resources.stone = resources.stone + 18
         kobo.hud_refresh(player)
         kobo.refresh[name] = false
         core.close_formspec(name, 'kobo:logging_1')
      elseif fields.repair then
         local pos = kobo.player_pos[name]
         local new_pos = vector.add(pos, {x=0, y=1, z=0})
         core.set_node(new_pos, {name='kobo:repair'})
         core.chat_send_player(name, 'Summonend a repairman.')
      end
   elseif formname == 'kobo:logging_2' then
      local name = player:get_player_name()
      local pos = kobo.player_pos[name]
      if fields.add_trees then
         local resources = kobo.resources[name] or {}
         if resources.lumber >= 50 and resources.stone >= 25 then
            local pos1 = vector.add(pos, {x=-1, y=0, z=-1})
            local pos2 = vector.add(pos, {x=1, y=0, z=1})
            local open_space = core.find_nodes_in_area(pos1, pos2, 'air')
            if #open_space >= 1 then
               local spot = math.random(1, #open_space)
               core.set_node(open_space[spot], {name = 'kobo:evergreen_1'})
               local timer = core.get_node_timer(open_space[spot])
               timer:start(300)
               resources.stone = resources.stone - 25
               resources.lumber = resources.lumber - 100
               kobo.hud_refresh(player)
            else
               pos1 = vector.add(pos, {x=-2, y=0, z=-2})
               pos2 = vector.add(pos, {x=2, y=0, z=2})
               open_space = core.find_nodes_in_area(pos1, pos2, 'air')
               if #open_space >= 1 then
                  local spot = math.random(1, #open_space)
                  core.set_node(open_space[spot], {name = 'kobo:evergreen_1'})
                  local timer = core.get_node_timer(open_space[spot])
                  timer:start(300)
                  resources.stone = resources.stone - 25
                  resources.lumber = resources.lumber - 100
                  kobo.hud_refresh(player)
               end
            end
         else
            core.chat_send_player(name, 'You need more resources.')
         end
      elseif fields.remove then
         local resources = kobo.resources[name]
         core.remove_node(pos)
         resources.food = resources.food + 37
         resources.lumber = resources.lumber + 150
         resources.stone = resources.stone + 36
         kobo.hud_refresh(player)
         core.close_formspec(name, 'kobo:logging_2')
         kobo.refresh[name] = false
      elseif fields.repair then
         local pos = kobo.player_pos[name]
         local new_pos = vector.add(pos, {x=0, y=1, z=0})
         core.set_node(new_pos, {name='kobo:repair'})
         core.chat_send_player(name, 'Summonend a repairman.')
      end
   end
end)
