local function shorten(number, decimal)
   if number > 1000 then
      number = number / 1000
      local mult = 10^(decimal or 0)
      number = (math.floor(number * mult + 0.5) / mult)..' K'
   end
   return number
end

core.register_on_joinplayer(function(player)
   player:hud_set_flags({wielditem = false, minimap_radar = false, minimap = false})
   local name = player:get_player_name()
   local resources = kobo.resources[name]
   kobo.hud[name] = {
      background = player:hud_add({
         type          = 'image',
         text          = 'kobo_hud_bg.png',
         position      = {x = 1, y = 0},
         offset        = {x = 0,   y = 0},
         alignment     = {x = -1, y = 1},
         scale         = {x = 1, y = 1},
         size          = {x = 2},
         z_index       = -100
      }),
      food = player:hud_add({
         type          = 'text',
         position      = {x = 1, y = 0},
         offset        = {x = -850,   y = 20},
         text          = 'Food: '..shorten(resources.food, 2),
         alignment     = {x = 1, y = 0},
         scale         = {x = 100, y = 100},
         size          = {x = 2}
      }),
      food_ico = player:hud_add({
         type          = 'image',
         text          = 'kobo_food.png',
         position      = {x = 1, y = 0},
         offset        = {x = -900,   y = 20},
         alignment     = {x = 1, y = 0},
         scale         = {x = .3, y = .3},
      }),
      lumber = player:hud_add({
         type          = 'text',
         position      = {x = 1, y = 0},
         offset        = {x = -850,   y = 60},
         text          = 'Lumber: '..shorten(resources.lumber, 2),
         alignment     = {x = 1, y = 0},
         scale         = {x = 100, y = 100},
         size          = {x = 2}
      }),
      lumber_ico = player:hud_add({
         type          = 'image',
         text          = 'kobo_lumber.png',
         position      = {x = 1, y = 0},
         offset        = {x = -900,   y = 60},
         alignment     = {x = 1, y = 0},
         scale         = {x = .3, y = .3},
      }),
      stone = player:hud_add({
         type          = 'text',
         position      = {x = 1, y = 0},
         offset        = {x = -550,   y = 20},
         text          = 'Stone: '..shorten(resources.stone, 2),
         alignment     = {x = 1, y = 0},
         scale         = {x = 100, y = 100},
         size          = {x = 2}
      }),
      stone_ico = player:hud_add({
         type          = 'image',
         text          = 'kobo_stone.png',
         position      = {x = 1, y = 0},
         offset        = {x = -600,   y = 20},
         alignment     = {x = 1, y = 0},
         scale         = {x = .3, y = .3},
      }),
      metal = player:hud_add({
         type          = 'text',
         position      = {x = 1, y = 0},
         offset        = {x = -550,   y = 60},
         text          = 'Metal: '..shorten(resources.metal, 2),
         alignment     = {x = 1, y = 0},
         scale         = {x = 100, y = 100},
         size          = {x = 2}
      }),
      metal_ico = player:hud_add({
         type          = 'image',
         text          = 'kobo_metal.png',
         position      = {x = 1, y = 0},
         offset        = {x = -600,   y = 60},
         alignment     = {x = 1, y = 0},
         scale         = {x = .3, y = .3},
      }),
      inv = player:hud_add({
         type          = 'inventory',
         position      = {x = .01, y = .5},
         offset        = {x = 0, y = 0},
         size          = {x = 8, y = 8},
         text          = 'hand',
         number        = 1,
         direction     = 0,
         item          = 1,
      }),
      map = player:hud_add({
         type          = 'minimap',
         position      = {x = 1, y = 0},
         size          = {x = 650, y = 650},
      }),
}
end)

function kobo.hud_refresh(player)
   local name = player:get_player_name()
   local resources = kobo.resources[name]
   local idx = kobo.hud[name]
   player:hud_change(idx.food, 'text', 'Food: '..shorten(resources.food, 2))
   player:hud_change(idx.lumber, 'text', 'Lumber: '..shorten(resources.lumber, 2))
   player:hud_change(idx.stone, 'text', 'Stone: '..shorten(resources.stone, 2))
   player:hud_change(idx.metal, 'text', 'Metal: '..shorten(resources.metal, 2))
end
