local function storage_overview(pos, tier)
   local max_health = 250
   if tier == 2 then
      max_health = 500
   end
   local meta = core.get_meta(pos)
   local health = meta:get_int('health')
   local scale = (health/max_health) * 3

   local formspec =
      kobo.building_inv..
      'textarea[3.25,0;7.5,1;;;Storage pit]'..
      'image[0,0;3,3;kobo_storage_'..tier..'_snap.png]'..
      'image_button[3.25,2;1,1;kobo_courier_ico.png;courier;;true;false]]'..
      'tooltip[courier;Create a courier (15 lumber, 5 metal, 50 food);black;white]'..
      'image[0,3.75;'..scale..',.25;kobo_health_fg.png]'

   return formspec
end

local function storage_overview_wrapper(player, pos, tier)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:storage', storage_overview(pos, tier))
      core.after(.25, function()
         storage_overview_wrapper(player, pos, tier)
      end)
   end
end

local stor_1_col = {
   type = 'fixed',
   fixed = {{-.4375, -.4375, -.4375, .4375, -.25, .4375}}
   }

local stor_1_sel = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.5, .5, 0, .5}}
   }

core.register_node('kobo:storage_1', {
   description = 'Storage pit',
   drawtype = 'mesh',
   mesh = 'kobo_storage_1.obj',
   tiles = {'kobo_storage_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   selection_box = stor_1_sel,
   collision_box = stor_1_col,
   groups = {storage=1, player_building=1},
   _snapshot = 'kobo_storage_1_snap.png',
   _cost = {100, 100, 50, 500},
   _health = 250,
   _max_inv = 'No Max',
   _long_desc = 'A basic storage facility.',
   after_place_node = function(pos, placer)
      local player_name = placer:get_player_name()
      local meta = core.get_meta(pos)
      meta:set_string('owner', player_name)
      meta:set_int('health', 250)
      kobo.place_lights(pos)
   end,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         local player_inv = clicker:get_inventory()
         local items = player_inv:get_stack('hand', 1)
         local item_name = items:get_name()
         local item_count = items:get_count()
         local resources = kobo.resources[player_name] or {}
         if item_name == 'kobo:lumber' then
            resources.lumber = resources.lumber + item_count
         elseif item_name == 'kobo:stone' then
            resources.stone = resources.stone + item_count
         elseif item_name == 'kobo:food' then
            resources.food = resources.food + item_count
         elseif item_name == 'kobo:metal' then
            resources.metal = resources.metal + item_count
         end
         player_inv:set_list('hand', {})
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         storage_overview_wrapper(player_name, pos, 1)
         kobo.hud_refresh(clicker)
         kobo.save()
      end
   end,
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:storage' then
      local name = player:get_player_name()
      if fields.courier then
         local resources = kobo.resources[name] or {}
         if resources.lumber >= 15 and resources.food >= 50 and resources.metal >= 5 then
            local pos = kobo.player_pos[name]
            local home_pos = vector.add(pos, {x=0, y=1, z=0})
            local courier = minetest.add_entity(pos, 'kobo:courier')
            local courier_entity = courier:get_luaentity()
            courier_entity.owner = name
            courier_entity.home = home_pos
            courier_entity.state = 'idle'
            courier_entity.inv = 0
            courier_entity.mat = ''
            resources.lumber = resources.lumber - 15
            resources.food = resources.food - 50
            resources.metal = resources.metal - 5
            kobo.hud_refresh(player)
         else
            core.chat_send_player(name, 'You need more resources.')
         end
      elseif fields.remove then
         local pos = kobo.player_pos[name]
         local resources = kobo.resources[name] or {}
         resources.food = resources.food + 75
         resources.lumber = resources.lumber + 75
         resources.metal = resources.metal + 375
         resources.stone = resources.stone + 375
         core.remove_node(pos)
         kobo.refresh[name] = false
         kobo.hud_refresh(player)
         core.close_formspec(name, 'kobo:storage')
      elseif fields.repair then
         local pos = kobo.player_pos[name]
         local new_pos = vector.add(pos, {x=0, y=1, z=0})
         core.set_node(new_pos, {name='kobo:repair'})
         core.chat_send_player(name, 'Summonend a repairman.')
      end
   end
end)
