local function tower_overview(pos)
   local meta = core.get_meta(pos)
   local health = meta:get_int('health')
   local scale = (health/200) * 3
   local formspec =
      kobo.building_inv..
      'textarea[3.25,0;7.5,1;;;Achery Tower]'..
      'image[0,0;3,3;kobo_tower_snap.png]'..
      'textarea[3.25,.75;7.5,2.25;;;Slaughter the incoming hordes of puny goblins with this death machine.]'..
      'image[0,3.75;'..scale..',.25;kobo_health_fg.png]'
   return formspec
end

local function tower_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:tower', tower_overview(pos))
      core.after(.25, function()
         tower_overview_wrapper(player, pos)
      end)
   end
end

local tower_col = {
   type = 'fixed',
   fixed = {{-.4375, -.5, -.4375, .4375, -.3125, .4375}}
   }

local tower_sel = {
   type = 'fixed',
   fixed = {{-.4375, -.5, -.4375, .4375, 1.25, .4375}}
   }

core.register_node('kobo:tower', {
   description = 'Archery Tower',
   drawtype = 'mesh',
   mesh = 'kobo_tower.obj',
   tiles = {'kobo_tower.png'},
   paramtype = 'light',
   range = 15,
   selection_box = tower_sel,
   collision_box = tower_col,
   groups = {player_building=1},
   _snapshot = 'kobo_tower_snap.png',
   _cost = {0, 50, 0, 100},
   _health = 200,
   _max_inv = 0,
   _long_desc = 'Slaughter the incoming hordes of puny goblins with this death machine.',
   after_place_node = function(pos, placer)
      local pos_check = vector.subtract(pos, {x=0, y=1, z=0})
      local node_check = core.get_node(pos_check)
      local player_name = placer:get_player_name()
      if core.get_item_group(node_check.name, 'ground') > 0 then
         local timer = core.get_node_timer(pos)
         local meta = core.get_meta(pos)
         local resources = kobo.resources[player_name]
         meta:set_string('owner', player_name)
         meta:set_int('health', 200)
         kobo.place_lights(pos)
         resources.xp = resources.xp + 1
         timer:start(1)
      else
         core.chat_send_player(player_name, 'You can\'t place this here.')
         core.remove_node(pos)
         return true
      end
   end,
   after_destruct = function(pos)
      kobo.remove_lights(pos)
   end,
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         tower_overview_wrapper(player_name, pos)
         kobo.save()
      end
   end,
   on_timer = function(pos)
      local timer = core.get_node_timer(pos)
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      local count = 0
      for obj in core.objects_inside_radius(pos, 5) do
         if count >= 5 then break end
         local entity = obj:get_luaentity()
         if entity then
            if not core.is_player(obj) then
               if entity.name ~= 'kobo:goblin_tombstone' then
                  if entity.owner ~= owner then
                     entity.health = entity.health - 1 or 24
                     count = count + 1
                     if entity.health <= 0 then
                        local resources = kobo.resources[owner]
                        if entity.name == 'kobo:goblin_rogue' then
                           resources.xp = resources.xp + 5
                           resources.metal = resources.metal + 1
                           entity.object:remove()
                        else
                           entity.object:remove()
                           resources.xp = resources.xp + 1
                        end
                     end
                  end
               end
            end
         end
      end
      --object:punch(puncher, time_from_last_punch, tool_capabilities, direction)
      timer:start(1)
   end,
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:tower' then
      local name = player:get_player_name()
      if fields.remove then
         local resources = kobo.resources[name] or {}
         resources.lumber = resources.lumber + 37
         resources.stone = resources.stone + 75
         local pos = kobo.player_pos[name]
         core.remove_node(pos)
         kobo.refresh[name] = false
         kobo.hud_refresh(player)
         core.close_formspec(name, 'kobo:tower')
      elseif fields.repair then
         local pos = kobo.player_pos[name]
         local new_pos = vector.add(pos, {x=0, y=1, z=0})
         core.set_node(new_pos, {name='kobo:repair'})
         core.chat_send_player(name, 'Summonend a repairman.')
      end
   end
end)
