function kobo.load()
   local file = io.open(core.get_worldpath() .. '/data', 'r')
   if file then
      local data = core.deserialize(file:read('*a'))
      file:close()
      kobo.resources = data.resources
      kobo.bases = data.bases
      kobo.goblins = data.goblins or {}
   else
      kobo.resources = {} --food, lumber, metal, stone, xp, research points
      kobo.bases = {}
      local resources = {}
      resources.xp = 0
      resources.wave = 0
      resources.food = 100
      resources.lumber = 20
      resources.stone = 0
      resources.metal = 0
      resources.nearest_base = {}
      kobo.goblins = resources
   end
end

function kobo.save()
   local save = {}
   save.resources = kobo.resources
   save.bases = kobo.bases
   save.goblins = kobo.goblins
   local file = io.open(core.get_worldpath() .. '/data', 'w')
   file:write(core.serialize(save))
   file:close()
end
