local function wall_overview(pos)
   local meta = core.get_meta(pos)
   local health = meta:get_int('health')
   local scale = (health/150) * 3
   local formspec =
      kobo.building_inv..
      'textarea[3.25,0;7.5,1;;;Wooden Wall]'..
      'image[0,0;3,3;kobo_wall_1_snap.png]'..
      'textarea[3.25,.75;7.5,2.25;;;Basic defense to keep the goblins out.]'..
      'image[0,3.75;'..scale..',.25;kobo_health_fg.png]'
   return formspec
end

local function wall_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:wall_1', wall_overview(pos))
      core.after(.25, function()
         wall_overview_wrapper(player, pos)
      end)
   end
end

local wall_box_straight = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.125, .5, 0, .125}}
   }

local wall_box_corner = {
   type = 'fixed',
   fixed = {{-.125, -.5, -.125, .5, 0, .125},
            {-.125, -.5, -.5, .125, 0, -.125}}
   }

local wall_box_t = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.125, .5, 0, .125},
            {-.125, -.5, -.125, .125, 0, .5}}
   }

local wall_box_x = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.125, .5, 0, .125},
            {-.125, -.5, -.5, .125, 0, .5}}
   }

local function update_node(pos, check_surrounding, placing)
   local shape = 0
   local pos1 = vector.add(pos, {x=1, y=0, z=0})
   local node1 = core.get_node(pos1)
   local pos2 = vector.add(pos, {x=0, y=0, z=1})
   local node2 = core.get_node(pos2)
   local pos3 = vector.add(pos, {x=-1, y=0, z=0})
   local node3 = core.get_node(pos3)
   local pos4 = vector.add(pos, {x=0, y=0, z=-1})
   local node4 = core.get_node(pos4)
   if core.get_item_group(node1.name, 'player_walls') > 0 then
      shape = shape + 1000
      if check_surrounding then
         update_node(pos1, false, true)
      end
   end
   if core.get_item_group(node2.name, 'player_walls') > 0 then
      shape = shape + 100
      if check_surrounding then
         update_node(pos2, false, true)
      end
   end
   if core.get_item_group(node3.name, 'player_walls') > 0 then
      shape = shape + 10
      if check_surrounding then
         update_node(pos3, false, true)
      end
   end
   if core.get_item_group(node4.name, 'player_walls') > 0 then
      shape = shape + 1
      if check_surrounding then
         update_node(pos4, false, true)
      end
   end
   if placing then
      if shape == 1001 then
         core.swap_node(pos, {name = 'kobo:wall_1_corner', param2 = 0})
      elseif shape == 11 then
         core.swap_node(pos, {name = 'kobo:wall_1_corner', param2 = 1})
      elseif shape == 1100 then
         core.swap_node(pos, {name = 'kobo:wall_1_corner', param2 = 3})
      elseif shape == 110 then
         core.swap_node(pos, {name = 'kobo:wall_1_corner', param2 = 2})
      elseif shape == 1 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 1})
      elseif shape == 100 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 1})
      elseif shape == 101 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 1})
      elseif shape == 1110 then
         core.swap_node(pos, {name = 'kobo:wall_1_t', param2 = 0})
      elseif shape == 1010 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 2})
      elseif shape == 1000 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 2})
      elseif shape == 10 then
         core.swap_node(pos, {name = 'kobo:wall_1_straight', param2 = 2})
      elseif shape == 1101 then
         core.swap_node(pos, {name = 'kobo:wall_1_t', param2 = 1})
      elseif shape == 111 then
         core.swap_node(pos, {name = 'kobo:wall_1_t', param2 = 3})
      elseif shape == 1011 then
         core.swap_node(pos, {name = 'kobo:wall_1_t', param2 = 2})
      elseif shape == 1111 then
         core.swap_node(pos, {name = 'kobo:wall_1_x', param2 = 0})
      end
   end
end

core.register_node('kobo:wall_1_straight', {
   description = 'Wooden Wall',
   drawtype = 'mesh',
   mesh = 'kobo_wall_1_straight.obj',
   tiles = {'kobo_wall_1_straight.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   light_source = 4,
   selection_box = wall_box_straight,
   collision_box = wall_box_straight,
   groups = {player_building=1, player_walls=1},
   _snapshot = 'kobo_wall_1_snap.png',
   _cost = {0, 100, 0 ,0},
   _health = 150,
   _max_inv = 0,
   _long_desc = 'Basic defense to keep the goblins out.',
   after_place_node = function(pos, placer)
      local pos_check = vector.subtract(pos, {x=0, y=1, z=0})
      local node_check = core.get_node(pos_check)
      local player_name = placer:get_player_name()
      if core.get_item_group(node_check.name, 'ground') > 0 then
         local meta = core.get_meta(pos)
         meta:set_string('owner', player_name)
         meta:set_int('health', 150)
         update_node(pos, true, true)
      end
   end,
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         wall_overview_wrapper(player_name, pos)
         kobo.save()
      end
   end,
   after_destruct = function(pos)
      update_node(pos, true, false)
      core.remove_node(vector.add(pos, {x=0, y=1, z=0}))
   end,
})

core.register_node('kobo:wall_1_corner', {
   description = 'Wooden Wall',
   drawtype = 'mesh',
   mesh = 'kobo_wall_1_corner.obj',
   tiles = {'kobo_wall_1_corner.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   light_source = 4,
   selection_box = wall_box_corner,
   collision_box = wall_box_corner,
   groups = {player_building=1, player_walls=1},
   _snapshot = 'kobo_wall_1_snap.png',
   _cost = {0, 100, 0 ,0},
   _health = 150,
   _max_inv = 0,
   _long_desc = 'Basic defense to keep the goblins out.',
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         wall_overview_wrapper(player_name, pos)
         kobo.save()
      end
   end,
   after_destruct = function(pos)
      update_node(pos, true)
   end,
})

core.register_node('kobo:wall_1_t', {
   description = 'Wooden Wall',
   drawtype = 'mesh',
   mesh = 'kobo_wall_1_t.obj',
   tiles = {'kobo_wall_1_t.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   light_source = 4,
   selection_box = wall_box_t,
   collision_box = wall_box_t,
   groups = {player_building=1, player_walls=1},
   _snapshot = 'kobo_wall_1_snap.png',
   _cost = {0, 100, 0 ,0},
   _health = 150,
   _max_inv = 0,
   _long_desc = 'Basic defense to keep the goblins out.',
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         wall_overview_wrapper(player_name, pos)
         kobo.save()
      end
   end,
   after_destruct = function(pos)
      update_node(pos, true)
   end,
})

core.register_node('kobo:wall_1_x', {
   description = 'Wooden Wall',
   drawtype = 'mesh',
   mesh = 'kobo_wall_1_x.obj',
   tiles = {'kobo_wall_1_x.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   range = 15,
   light_source = 4,
   selection_box = wall_box_x,
   collision_box = wall_box_x,
   groups = {player_building=1, player_walls=1},
   _snapshot = 'kobo_wall_1_snap.png',
   _cost = {0, 100, 0 ,0},
   _health = 150,
   _max_inv = 0,
   _long_desc = 'Basic defense to keep the goblins out.',
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local owner = meta:get_string('owner')
      if owner == player_name or core.check_player_privs(clicker, {server = true}) then
         kobo.player_pos[player_name] = pos
         kobo.refresh[player_name] = true
         wall_overview_wrapper(player_name, pos)
         kobo.save()
      end
   end,
   after_destruct = function(pos)
      update_node(pos, true)
   end,
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:wall_1' then
      local name = player:get_player_name()
      if fields.remove then
         local resources = kobo.resources[name] or {}
         resources.lumber = resources.lumber + 75
         local pos = kobo.player_pos[name]
         core.remove_node(pos)
         kobo.refresh[name] = false
         kobo.hud_refresh(player)
         core.close_formspec(name, 'kobo:wall_1')
      elseif fields.repair then
         local pos = kobo.player_pos[name]
         local new_pos = vector.add(pos, {x=0, y=1, z=0})
         core.set_node(new_pos, {name='kobo:repair'})
         core.chat_send_player(name, 'Summonend a repairman.')
      end
   end
end)
