local function courier_overview(obj)
   local scale = (obj.inv/30) * 3
   local formspec =
   kobo.unit_inv..
   'textarea[3.25,0;7.5,1;;;Courier]'..
   'image[0,0;3,3;kobo_courier_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;Courier state: '..obj.state..'.\n'..
   'Courier inventory: '..obj.inv..' '..obj.mat..'.]'..
   'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   return formspec
end

core.register_entity('kobo:courier', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'kobo_worker.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collide_with_objects = false,
      collisionbox = {-.125, -.5, -.125, .125, 0, .125},
      textures = {'kobo_courier.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      local data = core.deserialize(staticdata)
      if data then
         self.node_timer = data.node_timer
         self.owner = data.owner
         self.home = data.home
         self.state = data.state
         self.path = data.path
         self.step = data.step
         self.inv = data.inv
         self.last_job = data.last_job
         self.mat = data.mat
      end
   end,

   get_staticdata = function(self)
      local data ={}
      data.node_timer = self.node_timer
      data.owner = self.owner
      data.home = self.home
      data.state = self.state
      data.path = self.path
      data.step = self.step
      data.inv = self.inv
      data.last_job = self.last_job
      data.mat = self.mat
      return core.serialize(data)
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         if self.state == 'idle' then --Find the lazybones some work.
            if self.inv >= 1 then
               local self_pos = self.object:get_pos()
               local node = core.get_node(self_pos)
               local def = core.registered_nodes[node.name]
               if def.walkable then
                  self_pos = vector.add(self_pos, {x=0, y=1, z=0})
               end
               local storage_point = core.find_node_near(self_pos, 10, 'group:storage')
               if storage_point then
                  local path = core.find_path(self_pos, vector.add(storage_point, {x=0, y=1, z=0}), 5, 1, .75)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  end
               end
            else
               local last_job = self.last_job
               if not last_job then
                  local self_pos = self.object:get_pos()
                  local pos1 = vector.add(self_pos, {x=-10, y=0, z=-10})
                  local pos2 = vector.add(self_pos, {x=10, y=0, z=10})
                  local col_point = core.find_nodes_in_area(pos1, pos2, 'group:collector')
                  if #col_point >= 1 then
                     local pick = math.random(1, #col_point)
                     local meta = core.get_meta(col_point[pick])
                     local inventory = meta:get_int('inventory')
                     if inventory >= 30 then
                     local node = core.get_node(self_pos)
                     local def = core.registered_nodes[node.name]
                     if def.walkable then
                        self_pos = vector.add(self_pos, {x=0, y=1, z=0})
                     end
                        local path = core.find_path(self_pos, vector.add(col_point[pick], {x=0, y=1, z=0}), 5, 1, 1)
                        if path then
                           self.path = path
                           self.step = 2
                           self.state = 'traveling'
                        end
                     else --Make the unit wander around for a while.
                        self.state = 'idle'
                     end
                  end
               else
                  local meta = core.get_meta(last_job)
                  local inventory = meta:get_int('inventory')
                  if inventory >= 30 then
                     local self_pos = self.object:get_pos()
                     local node = core.get_node(self_pos)
                     local def = core.registered_nodes[node.name]
                     if def.walkable then
                        self_pos = vector.add(self_pos, {x=0, y=1, z=0})
                     end
                     local path = core.find_path(self_pos, vector.add(last_job, {x=0, y=1, z=0}), 5, 1, 1)
                     if path then
                        self.path = path
                        self.step = 1
                        self.state = 'traveling'
                     end
                  else --Make the unit wander around for a while.
                     self.last_job = nil
                     self.state = 'idle'
                  end
               end
            end
         elseif self.state == 'traveling' then
            if #self.path > (self.step - 1) then
               local pos = self.object:get_pos()
               local perhaps = vector.direction(pos, self.path[self.step])
               self.object:set_velocity({x = perhaps.x, y = 0, z = perhaps.z})
               self.step = self.step + 1
            else
               local self_pos = vector.round(self.object:get_pos())
               local collection_spot = core.find_node_near(self_pos, 1, 'group:collector', true)
               if collection_spot then
                  local node = core.get_node(collection_spot)
                  local def = core.registered_nodes[node.name]
                  local material = def._material
                  self.object:set_velocity({x=0, y=0, z=0})
                  self.last_job = collection_spot
                  self.mat = material
                  self.state = 'working'
               elseif core.find_node_near(self_pos, 1, 'group:storage', true) then
                  local resources = kobo.resources[self.owner]
                  if self.mat == 'food' then
                     resources.food = resources.food + self.inv
                  elseif self.mat == 'lumber' then
                     resources.lumber = resources.lumber + self.inv
                  elseif self.mat == 'metal' then
                     resources.metal = resources.metal + self.inv
                  elseif self.mat == 'stone' then
                     resources.stone = resources.stone + self.inv
                  end
                  self.inv = 0
                  local player = core.get_player_by_name(self.owner)
                  kobo.hud_refresh(player)
                  self.state = 'idle'
               else
                  self.state = 'idle'
               end
            end
         elseif self.state == 'working' then
            local inventory_count = self.inv
            if inventory_count <= 20 then
               local pos = self.last_job
               local meta = core.get_meta(pos)
               local inventory = meta:get_int('inventory')
               if inventory >= 10 then
                  meta:set_int('inventory', inventory - 10)
                  self.inv = self.inv + 10
               elseif inventory == 0 then
                  self.state = 'idle'
               end
            else
               local self_pos = self.object:get_pos()
               local storage_point = core.find_node_near(self_pos, 10, 'group:storage')
               if storage_point then
                  local node = core.get_node(self_pos)
                  local def = core.registered_nodes[node.name]
                  if def.walkable then
                     self_pos = vector.add(self_pos, {x=0, y=1, z=0})
                  end
                  local path = core.find_path(self_pos, vector.add(storage_point, {x=0, y=1, z=0}), 5, 1, 1)
                  if path then
                     self.path = path
                     self.step = 2
                     self.state = 'traveling'
                  else --Make the unit wander around for a while.
                     self.state = 'idle'
                  end
               else
                  self.state = 'idle'
               end
            end
         end
      elseif moveresults.collides then
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local node_pos = moveresults.collisions[1].node_pos
            local node = core.get_node(node_pos)
            if core.get_item_group(node.name, 'storage') > 0 then
               local resources = kobo.resources[self.owner]
               if self.mat == 'food' then
                  resources.food = resources.food + self.inv
               elseif self.mat == 'lumber' then
                  resources.lumber = resources.lumber + self.inv
               elseif self.mat == 'metal' then
                  resources.metal = resources.metal + self.inv
               elseif self.mat == 'stone' then
                  resources.stone = resources.stone + self.inv
               end
               self.inv = 0
               self.state = 'idle'
               local player = core.get_player_by_name(self.owner)
               kobo.hud_refresh(player)
            elseif core.get_item_group(node.name, 'collector') > 0 then
               local node_pos = moveresults.collisions[1].node_pos
               local node = core.get_node(node_pos)
               local def = core.registered_nodes[node.name]
               local material = def._material
               self.object:set_velocity({x=0, y=0, z=0})
               self.last_job = node_pos
               self.mat = material
               self.state = 'working'
            end
         end
      end
   end,

   on_rightclick = function(self, clicker)
      local player_name = clicker:get_player_name()
      if self.owner == player_name or core.check_player_privs(clicker, {server = true}) then
         core.show_formspec(player_name, 'kobo:courier_overview', courier_overview(self))
      end
   end,

})
