function kobo.place_lights(pos)
   local above_pos = vector.add(pos, {x=0, y=2, z=0})
   local N_pos = vector.add(pos, {x=4, y=2, z=4})
   local S_pos = vector.add(pos, {x=-4, y=2, z=-4})
   local E_pos = vector.add(pos, {x=4, y=2, z=-4})
   local W_pos = vector.add(pos, {x=-4, y=2, z=4})
   core.set_node(above_pos, {name = 'kobo:light'})
   core.set_node(N_pos, {name = 'kobo:light_2'})
   core.set_node(S_pos, {name = 'kobo:light_2'})
   core.set_node(E_pos, {name = 'kobo:light_2'})
   core.set_node(W_pos, {name = 'kobo:light_2'})
end

function kobo.remove_lights(pos)
   local above_pos1 = vector.add(pos, {x=0, y=1, z=0})
   local above_pos2 = vector.add(pos, {x=0, y=2, z=0})
   local N_pos = vector.add(pos, {x=4, y=2, z=4})
   local S_pos = vector.add(pos, {x=-4, y=2, z=-4})
   local E_pos = vector.add(pos, {x=4, y=2, z=-4})
   local W_pos = vector.add(pos, {x=-4, y=2, z=4})
   core.remove_node(above_pos1)
   core.remove_node(above_pos2)
   core.remove_node(N_pos)
   core.remove_node(S_pos)
   core.remove_node(E_pos)
   core.remove_node(W_pos)
end

function kobo.add_player_inventory_hand(player, material)
   local player_inv = player:get_inventory()
   if player_inv:room_for_item('hand', {name = material}) then
      player_inv:add_item('hand', material)
      return true
   else
      core.chat_send_player(player:get_player_name(), 'You can\'t take that now.')
      return false
   end
end

function kobo.add_player_inventory_main(player, material)
   local player_inv = player:get_inventory()
   if player_inv:room_for_item('main', {name = material}) then
      player_inv:add_item('main', material)
      return true
   else
      core.chat_send_player(player:get_player_name(), 'No empty inventory slots.')
      return false
   end
end

local fdir_table = {
   { 1,  0},
   { 0, -1},
   {-1,  0},
   { 0,  1},
   { 1,  0},
   { 0, -1},
   {-1,  0},
   { 0,  1},
}

local corner_table = {
   { 1,  1},
   { 1, -1},
   {-1, -1},
   {-1,  1},
}

function kobo.space_for_building(pos)
   local node = core.get_node(pos)
   local fdir = node.param2 % 32
   local pos1 = {x = pos.x + fdir_table[fdir+1][1], y=pos.y, z = pos.z + fdir_table[fdir+1][2]} --right node
   local pos2 = {x = pos.x + fdir_table[fdir+4][1], y=pos.y, z = pos.z + fdir_table[fdir+4][2]} --far node
   local pos3 = {x = pos.x + corner_table[fdir+1][1], y=pos.y, z = pos.z + corner_table[fdir+1][2]} --opposite corner
   local node1 = core.get_node(pos1)
   local node2 = core.get_node(pos2)
   local node3 = core.get_node(pos3)
   if node1.name == 'air' and node2.name == 'air' and node3.name == 'air' then
      core.set_node(pos1,{name = 'kobo:empty'})
      core.set_node(pos2,{name = 'kobo:empty'})
      core.set_node(pos3,{name = 'kobo:empty'})
      return true
   else
      return false
   end
end

function kobo.remove_building_spaces(pos, oldnode)
   local fdir = oldnode.param2 % 32
   local pos1 = {x = pos.x + fdir_table[fdir+1][1], y=pos.y, z = pos.z + fdir_table[fdir+1][2]} --right node
   local pos2 = {x = pos.x + fdir_table[fdir+4][1], y=pos.y, z = pos.z + fdir_table[fdir+4][2]} --far node
   local pos3 = {x = pos.x + corner_table[fdir+1][1], y=pos.y, z = pos.z + corner_table[fdir+1][2]} --opposite corner
   local node1 = core.get_node(pos1)
   local node2 = core.get_node(pos2)
   local node3 = core.get_node(pos3)
   if node1.name == 'kobo:empty' and node2.name == 'kobo:empty' and node3.name == 'kobo:empty' then
      core.remove_node(pos1)
      core.remove_node(pos2)
      core.remove_node(pos3)
   end
end
