local formspec_basic =
   'formspec_version[7]'..
   'size[12,8]'..
   'style_type[image_button;textcolor=white;font_size=+8]'..
   'image_button[0,-.75;2.325,.75;blank.png;tab_1;Home;true;false;]'..
   'image_button[2.5,-.75;2.325,.75;blank.png;tab_2;Research;true;false;]'..
   'image_button[5,-.75;2.325,.75;blank.png;tab_3;Buildings;true;false;]'..
   'image_button[7.5,-.75;2.325,.75;blank.png;tab_4;Help;true;false;]'

local function tab_1(name) --Overview
   local resources = kobo.resources[name]
   local formspec =
      formspec_basic..
      'background[-1,-1;14,10;kobo_inv_bg_1.png]'..
      'style_type[textarea;textcolor=black;font_size=+10]'..
      'textarea[0,.125;4,4;;;Resources:\n'..
      '   Food: '..resources.food..'\n'..
      '   Lumber: '..resources.lumber..'\n'..
      '   Stone: '..resources.stone..'\n'..
      '   Metal: '..resources.metal..'\n'..
      'XP: '..resources.xp..'\n'..
      'Research Points: '..resources.research..']'..
      'image_button[0,7;1,1;kobo_fly.png;fly;]'..
      'image_button[1.5,7;1,1;kobo_walk.png;walk;]'..
      'style_type[tooltip;font_size=+10]'..
      'tooltip[fly;Switch to fly mode.;black;white]'..
      'tooltip[walk;Switch to walk mode.;black;white]'
   return formspec
end

local function tab_2(name) --Research
   local formspec =
      formspec_basic..
      'background[-1,-1;14,10;kobo_inv_bg_2.png]'..
      'style_type[textarea;textcolor=black;font_size=+10]'..
      'textarea[0,.125;12,8;;;Coming in a post game jam release.]'
   return formspec
end

local building_list = {'logging_1', 'logging_2', 'wall_1_straight', 'tower', 'farmhouse', 'storage_1'} --ordered list of keys

local function tab_3(name, building) --Buildings
   building = building or 'logging_1'
   local formspec =
      formspec_basic..
      'background[-1,-1;14,10;kobo_inv_bg_3.png]'
      --'image[0,.125;12,3;nul.png]' --probably remove
   local offset = 0
   for i = 1, #building_list do
      local key = building_list[i]
      local node_name = 'kobo:'..key
      local def = core.registered_nodes[node_name]
      local desc = def.description

      if i <= 8 then
         offset = (i-1)*.5
         formspec = formspec..
         'image_button['..(i-1)+offset..',.125;1.375,1.375;kobo_'..key..'_ico.png;'..key..';;true;false;]'..
         'tooltip['..key..';'..desc..';black;white]'
      elseif i > 8 or i <= 16 then
         offset = (i-1)*.5
         formspec = formspec..
         'image_button['..(i-1)+offset..',1.625;1.375,1.375;kobo_'..key..'_ico.png;'..key..';;true;false;]'..
         'tooltip['..key..';'..desc..';black;white]'
      end
   end
   local node_name = 'kobo:'..building
   local def = core.registered_nodes[node_name]
   local desc = def.description
   local snap = def._snapshot
   local cost = def._cost
   local max_inv = def._max_inv
   local health = def._health
   local long_desc = def._long_desc
   formspec = formspec..
   'image[0,3.5625;3,3;'..snap..']'..
   'hypertext[3.25,3.5625;8.75,5;nil;<tag name=small color=black size=20><style color=black size=25>'..desc..'\n'..
   'Cost:\n'..
   '<small>---Food: '..cost[1]..'\n'..
   '---Lumber: '..cost[2]..'\n'..
   '---Metal: '..cost[3]..'\n'..
   '---Stone: '..cost[4]..'\n</small>'..
   'Maximum Inventory: '..max_inv..'\n'..
   'Health: '..health..'\n'..
   'Description: '..long_desc..'\n</style>]'..
--   'button[0,7;3,1;buy_'..building..';Buy]'..
   'button[0,7;3,1;buy;Buy]'..
   'style_type[tooltip;textcolor=black;font_size=+10]'..
   'tooltip[buy_'..building..';Add to inventory;black;white]'
   return formspec
end

local help_text = [[   Koboldkrieg (German for Goblin Warfare) is a Tower Defense/Real-time Strategy hybrid. You are the overseer of a new colony settling in an unexplored land. Challenges and trials await you, but it's nothing your loyal band can't overcome.
   Create units and buildings to collect resources. Be on the lookout for the goblins, they like to steal resources whenever they can. Much like how you need resources to create units, so do the Goblins. The more resources they have, the more goblins will spawn in the waves.
   It's a good idea to build a tower as soon as you can, as that is your only real defense against goblins. Walls will slow them down, and you can punch them to damage them, but towers are the best.
   If you find yourself short on resources you can manually collect them by punching the resource source. Right-click on any storage building to drop off your resources. (this is intentionally crippled.) When you punch on a stone or metal mine the location is saved and relayed on to your workers so they can more easily harvest materials for you.
   Above all else try and protect your town center, you can only have one, and if goblins destroy it you lose!]]

local tab_4 = --Help
   formspec_basic..
   'background[-1,-1;14,10;kobo_inv_bg_4.png]'..
   'style_type[textarea;textcolor=black;font_size=+10]'..
   'textarea[0,.125;12,8;;;'..minetest.formspec_escape(help_text)..']'


core.register_on_joinplayer(function(player)
   local name = player:get_player_name()
   player:set_inventory_formspec(tab_1(name))
end)

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == '' then
      local name = player:get_player_name()
      if fields.tab_1 then
         core.show_formspec(name, '', tab_1(name))
      elseif fields.tab_2 then
         core.show_formspec(name, '', tab_2(name))
      elseif fields.tab_3 then
         kobo.building[name] = 'logging_1'
         core.show_formspec(name, '', tab_3(name, 'logging_1'))
      elseif fields.tab_4 then
         core.show_formspec(name, '', tab_4)
      elseif fields.walk then
         player:set_properties({
            eye_height = .5,
            collisionbox = {-.125, 0, -.125, .125, 0.25, .125},
            stepheight = .25,
         })
         player:set_physics_override({speed=.25})
      elseif fields.fly then
         player:set_properties({
            eye_height = 5.5,
            collisionbox = {-0.3, 0, -0.3, 0.3, 0.75, 0.3},
            stepheight = 1,
         })
         player:set_physics_override({speed=1})
      elseif fields.buy then
         local building = 'kobo:'..kobo.building[name]
         local def = core.registered_nodes[building]
         local cost = def._cost
         local resources = kobo.resources[name] or {}
         local cost_food = cost[1]
         local cost_lumber = cost[2]
         local cost_metal = cost[3]
         local cost_stone = cost[4]
         if resources.food >= cost_food and resources.lumber >= cost_lumber and resources.metal >= cost_metal and resources.stone >= cost_stone then
            if kobo.add_player_inventory_main(player, building) then
               resources.food = resources.food - cost_food
               resources.lumber = resources.lumber - cost_lumber
               resources.metal = resources.metal - cost_metal
               resources.stone = resources.stone - cost_stone
               kobo.hud_refresh(player)
            else
               core.chat_send_player(name, 'You don\'t have space in inventory.')
            end
         else
            core.chat_send_player(name, 'You don\'t have enough resources.')
         end
      else -- We handled any normal buttons so this must be a building, but we still have to check because of odd fields.
         for k in pairs(fields) do
            local node_name = 'kobo:'..k
            local def = core.registered_nodes[node_name]
            if def then
               core.show_formspec(name, '', tab_3(name, k))
               kobo.building[name] = k
            end
         end

      end
   end
end)
