local function metal_mine_1_overview(pos)
   local meta = core.get_meta(pos)
   local remaining = meta:get_int('remaining')
   if remaining == 0 then remaining = 250 end
   local scale = (remaining/250) * 3
   local formspec =
   kobo.resource_inv..
   'textarea[3.25,0;7.5,1;;;Metal Mine (small)]'..
   'image[0,0;3,3;kobo_metal_mine_1_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;\n'..
   'This mine has '..remaining..' metal remaining.]'..
   'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   return formspec
end

local function metal_mine_1_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:metal_mine', metal_mine_1_overview(pos))
      core.after(.25, function()
         metal_mine_1_overview_wrapper(player, pos)
      end)
   end
end

local function metal_mine_2_overview(pos)
   local meta = core.get_meta(pos)
   local remaining = meta:get_int('remaining')
   if remaining == 0 then remaining = 1000 end
   local scale = (remaining/1000) * 3
   local formspec =
   kobo.resource_inv..
   'textarea[3.25,0;7.5,1;;;Metal Mine (large)]'..
   'image[0,0;3,3;kobo_metal_mine_2_snap.png]'..
   'textarea[3.25,.75;7.5,2.25;;;\n'..
   'This mine has '..remaining..' metal remaining.]'..
   'image[0,4.5;'..scale..',.25;kobo_inv_fg.png]'
   return formspec
end

local function metal_mine_2_overview_wrapper(player, pos)
   local refresh = kobo.refresh[player]
   if refresh then
      core.show_formspec(player, 'kobo:metal_mine', metal_mine_2_overview(pos))
      core.after(.25, function()
         metal_mine_2_overview_wrapper(player, pos)
      end)
   end
end

local metal_mine_box = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.5, .5, 0, .5}}
   }

core.register_node('kobo:metal_mine_1', {
   description = 'Metal Mine',
   drawtype = 'mesh',
   mesh = 'kobo_metal_mine_1.obj',
   tiles = {'kobo_metal_mine_1.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {metal_mine=1},
   selection_box = metal_mine_box,
   collision_box = metal_mine_box,
   _initial_count = 250,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      kobo.player_pos[player_name] = pos
      kobo.refresh[player_name] = true
      metal_mine_1_overview_wrapper(player_name, pos)
   end,
   on_punch = function(pos, node, puncher, pointed_thing)
      local name = puncher:get_player_name()
      local resources = kobo.resources[name]
      resources.last_metal = pos
      local meta = core.get_meta(pos)
      local remaining = meta:get_int('remaining')
      if remaining == 0 then -- Mine hasn't been punched yet. Add to player inventory.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            meta:set_int('remaining', 249)
         end
      elseif remaining == 1 then --Last bit of stone, add to player inventory, and remove the node.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            core.remove_node(pos)
         end
      else --Add inventory to player, cap at some level.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            meta:set_int('remaining', remaining - 1)
         end
      end
   end,
})

core.register_node('kobo:metal_mine_2', {
   description = 'Metal Mine',
   drawtype = 'mesh',
   mesh = 'kobo_metal_mine_2.obj',
   tiles = {'kobo_metal_mine_2.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {metal_mine=1},
   selection_box = metal_mine_box,
   collision_box = metal_mine_box,
   _initial_count = 1000,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local player_name = clicker:get_player_name()
      kobo.player_pos[player_name] = pos
      kobo.refresh[player_name] = true
      metal_mine_2_overview_wrapper(player_name, pos)
   end,
   on_punch = function(pos, node, puncher, pointed_thing)
      local name = puncher:get_player_name()
      local resources = kobo.resources[name]
      resources.last_metal = pos
      local meta = core.get_meta(pos)
      local remaining = meta:get_int('remaining')
      if remaining == 0 then -- Mine hasn't been punched yet. Add to player inventory.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            meta:set_int('remaining', 999)
         end
      elseif remaining == 1 then --Last bit of stone, add to player inventory, and remove the node.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            core.remove_node(pos)
         end
      else --Add inventory to player, cap at some level.
         if kobo.add_player_inventory_hand(puncher, 'kobo:metal') then
            meta:set_int('remaining', remaining - 1)
         end
      end
   end,
})

core.register_craftitem('kobo:metal', {
   description = 'Metal',
   inventory_image = 'kobo_metal.png',
   stack_max = 15,
})


core.register_decoration({
      deco_type = 'simple',
      place_on = {'kobo:sand'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.0000001,
         spread = {x = 300, y = 20, z = 300},
         seed = 684351,
         octaves = 3,
         persist = 1
      },
      y_min = 0,
      y_max = 1,
      decoration = 'kobo:metal_mine_1',
      param2 = 0,
      param2_max = 3,
      biomes = {'desert'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'kobo:dirth'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.005,
         spread = {x = 300, y = 20, z = 300},
         seed = 6843157,
         octaves = 3,
         persist = .5
      },
      y_min = 0,
      y_max = 1,
      decoration = 'kobo:metal_mine_2',
      param2 = 0,
      param2_max = 3,
      biomes = {'wasteland'},
})

core.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'kobo:metal_mine' then
      if fields.remove then
         local name = player:get_player_name()
         local pos = kobo.player_pos[name]
         core.remove_node(pos)
         kobo.refresh[name] = false
         core.close_formspec(name, 'kobo:metal_mine')
      end
   end
end)
