function ls_map.add_inv(player, node)
   local player_inv = player:get_inventory()
   if player_inv:room_for_item('main', node) then
      player_inv:add_item('main', node)
   else
      local drop_pos = player:get_pos()
      core.add_item(drop_pos, node)
   end
end

core.register_lbm({
   label = 'tree maker',
   name = 'ls_map:trees',
   nodenames = {'ls_map:tree_trunk'},
   run_at_every_load = true,
   action = function(pos)
      local upper_pos = vector.add(pos, {x=0,y=3,z=0})
      local node = core.get_node(upper_pos)
      if node.name == 'air' then
         local lower_pos = vector.add(pos, {x=0,y=-1,z=0})
         local random_rot = math.random(0,239)
         local random_sel = math.random(1,4)
         core.set_node(upper_pos, {name = 'ls_map:tree_top_'..random_sel, param2 = random_rot})
         core.set_node(lower_pos, {name = 'ls_core:empty'})
      end
   end
})
