core.register_node('ls_crystal:short_range', {
   description = 'short range crystal',
   drawtype = 'mesh',
   mesh = 'ls_crystal_beacon_sr_on.obj',
   tiles = {'ls_crystal_beacon_sr_crystals_on.png', 'ls_crystal_beacon_sr_base_on.png'},
   groups = {breakable=2, non_blocking=1, beacons=1, attack=9},
   light_source = 10,
   after_place_node = function(pos, placer)
      local meta = core.get_meta(pos)
      local player_name = placer:get_player_name()
      meta:set_string('infotext', 'Short Range Crystal Beacon')
      meta:set_string('player_name', player_name)
      ls_crystal.update_lights(pos, 'sr', 6, 'update')
      ls_crystal.on_place_beacon(player_name, pos, 'sr')
   end,
   on_destruct = function(pos)
      local meta = core.get_meta(pos)
      local player_name = meta:get_string('player_name')
      local key = core.pos_to_string(pos)
      local other_beacons = ls_crystal.data[player_name][key].beacons_list
      ls_crystal.unlink_beacons(pos, player_name, other_beacons, true)
      ls_crystal.data[player_name][key] = nil
   end,
   on_timer = function(pos)
      local meta = core.get_meta(pos)
      local name = meta:get_string('player_name')
      local timer = core.get_node_timer(pos)
      ls_crystal.spawn_beacon_particles(pos, name)
      timer:start(10)
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      local key = core.pos_to_string(pos)
      local table = ls_crystal.data[name][key]
      print(dump(table))
   end,
   on_rightclick = function(pos, node, clicker)
      local player = clicker:get_player_name()
      core.show_formspec(player, 'ls_crystal:beacon_overview', ls_crystal_beacon_overview(pos, player))
   end,
})

core.register_node('ls_crystal:long_range', {
   description = 'long range crystal',
   drawtype = 'mesh',
   mesh = 'ls_crystal_beacon_lr_on.obj',
   tiles = {'ls_crystal_beacon_lr_crystals_on.png', 'ls_crystal_beacon_lr_base_on.png'},
   groups = {breakable=2, non_blocking=1, beacons=1, attack=10},
   light_source = 14,
   after_place_node = function(pos, placer)
      local meta = core.get_meta(pos)
      local player_name = placer:get_player_name()
      meta:set_string('infotext', 'Long Range Crystal Beacon')
      meta:set_string('player_name', player_name)
      ls_crystal.update_lights(pos, 'lr', 8, 'place')
      ls_crystal.on_place_beacon(player_name, pos, 'lr')
   end,
   on_destruct = function(pos) --remove beacons table entry.
      local meta = core.get_meta(pos)
      local player_name = meta:get_string('player_name')
      local key = core.pos_to_string(pos)
      local other_beacons = ls_crystal.data[player_name][key].beacons_list
      ls_crystal.unlink_beacons(pos, player_name, other_beacons, true)
      ls_crystal.data[player_name][key] = nil
   end,
   on_timer = function(pos)
      local meta = core.get_meta(pos)
      local name = meta:get_string('player_name')
      local timer = core.get_node_timer(pos)
      ls_crystal.spawn_beacon_particles(pos, name)
      timer:start(10)
   end,
   on_rightclick = function(pos, node, clicker)
      local player = clicker:get_player_name()
      core.show_formspec(player, 'ls_crystal:beacon_overview', ls_crystal_beacon_overview(pos, player))
   end,
})
