local workbench_table_functions = simplecrafting_lib.generate_table_functions('workbench', {
   show_guides = true,
   alphabetize_items = true,})

local workbench_table_def = {
   description = 'Workbench',
   drawtype = 'mesh',
   mesh = 'ls_stations_workbench.obj',
   tiles = {'ls_stations_workbench.png'},
   use_texture_alpha = 'opaque',
--   sounds = default.node_sound_wood_defaults(),
   paramtype2 = 'facedir',
   paramtype = 'light',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5},
      },
   groups = {breakable=2, attack=5},
   after_place_node = function(pos, placer, itemstack)
      if not ls_core.space_to_side(pos) then
         core.remove_node(pos)
         return itemstack
      end
      local meta = core.get_meta(pos)
      meta:set_string('infotext', 'Workbench')
   end,
   after_destruct = function(pos, oldnode)
      ls_core.remove_side_node(pos, oldnode)
      local inv = core.get_meta(pos):get_inventory()
      for i = 1, inv:get_size('input') do
         local stk = inv:get_stack('input', i)
         local clean_dir = vector.multiply(vector.random_direction(), {x=1,y=0,z=1})
         pos = vector.add(clean_dir, pos)
         core.add_item(pos, stk)
      end
   end,
   on_rotate = function(pos, node)
      return false
   end,
}
for k, v in pairs(workbench_table_functions) do
   workbench_table_def[k] = v
end

core.register_node('ls_stations:workbench', workbench_table_def)
