core.register_craftitem('ls_items:log', {
   description = 'Log',
   inventory_image = 'ls_items_log_inv.png'
})

core.register_craftitem('ls_items:plank', {
   description = 'Plank',
   inventory_image = 'ls_items_plank_inv.png'
})

core.register_craftitem('ls_items:stone', {
   description = 'Stone',
   inventory_image = 'ls_items_stone_inv.png'
})

core.register_craftitem('ls_items:metal_lump', {
   description = 'Metal Lump',
   inventory_image = 'ls_items_metal_lump_inv.png',
   groups = {cookable=1},
   _cook_times = {10, 9, 7.5, 5}
})

core.register_craftitem('ls_items:metal_ingot', {
   description = 'Metal Ingot',
   inventory_image = 'ls_items_metal_ingot_inv.png'
})

core.register_craftitem('ls_items:meat_raw', {
   description = 'Raw Meat',
   inventory_image = 'ls_items_meat_raw.png',
   groups = {cookable=1},
   _cook_times = {5, 4.5, 3.5, 2.5}
})

core.register_craftitem('ls_items:meat_cooked', {
   description = 'Cooked Meat',
   inventory_image = 'ls_items_meat_cooked.png',
   on_use = function(itemstack, user, pointed_thing)
      local hp = user:get_hp()
      user:set_hp(hp+10)
      itemstack:take_item(1); return itemstack
   end
})

core.register_craftitem('ls_items:dirt', {
   description = 'Dirt',
   inventory_image = 'ls_items_dirt_inv.png',
   on_place = function(itemstack, placer, pointed_thing)
      local under = core.get_node(pointed_thing.under)
      local def = core.registered_nodes[under.name]
      if def and def.on_rightclick and
         not (placer and placer:is_player() and
         placer:get_player_control().sneak) then
         return def.on_rightclick(pointed_thing.under, under, placer, itemstack,
            pointed_thing) or itemstack
      end
      if core.get_item_group(under.name, 'dirt') > 0 then
         local def = core.registered_nodes[under.name]
         local level = def._level
         if level < 4 then
            core.swap_node(pointed_thing.under, {name = 'ls_map:dirt_'..level+1})
            itemstack:take_item()
            return itemstack
         elseif level == 4 then
            local above = vector.add(pointed_thing.under, {x=0,y=1,z=0})
            local above_node = core.get_node(above)
            local def = core.registered_items[above_node.name]
            if def and def.buildable_to == true then
               core.set_node(above, {name = 'ls_map:dirt_1'})
               itemstack:take_item()
               return itemstack
            end
         end
      else
         local above = vector.add(pointed_thing.under, {x=0,y=1,z=0})
         local above_node = core.get_node(above)
         local def = core.registered_items[above_node.name]
         if def and def.buildable_to == true then
            core.set_node(above, {name = 'ls_map:dirt_1'})
            itemstack:take_item()
            return itemstack
         end
      end
   end
})

core.register_craftitem('ls_items:gravel', {
   description = 'Gravel',
   inventory_image = 'ls_items_gravel_inv.png',
   on_place = function(itemstack, placer, pointed_thing)
      local node = core.get_node(pointed_thing.under)
      if core.get_item_group(node.name, 'gravel') > 0 then
         local def = core.registered_nodes[node.name]
         local level = def._level
         if level < 4 then
            core.swap_node(pointed_thing.under, {name = 'ls_map:gravel_'..level+1})
            itemstack:take_item()
            return itemstack
         elseif level == 4 then
            local above = vector.add(pointed_thing.under, {x=0,y=1,z=0})
            local above_node = core.get_node(above)
            local def = core.registered_items[above_node.name]
            if def and def.buildable_to == true then
               core.set_node(above, {name = 'ls_map:gravel_1'})
               itemstack:take_item()
               return itemstack
            end
         end
      else
         local above = vector.add(pointed_thing.under, {x=0,y=1,z=0})
         local above_node = core.get_node(above)
         local def = core.registered_items[above_node.name]
         if def and def.buildable_to == true then
            core.set_node(above, {name = 'ls_map:gravel_1'})
            itemstack:take_item()
            return itemstack
         end
      end
   end
})
