function ls_mobs.get_path(current_pos, destination_pos)
   local pos1 = vector.add(destination_pos, {x=-1, y=0, z=-1})
   local pos2 = vector.add(destination_pos, {x=1, y=0, z=1})
   local air = core.find_nodes_in_area(pos1, pos2, {'air'})
   if #air > 0 then
      local pick = math.random(1, #air)
      local path = core.find_path(current_pos, air[pick], 15, 10, 10)
      if path then
         table.insert(path, destination_pos)
         return path
      end
   end
end

function ls_mobs.spawn_unit(pos, unit)
   local pos1 = vector.add(pos, {x=-1, y=0, z=-1})
   local pos2 = vector.add(pos, {x=1, y=0, z=1})
   local air = core.find_nodes_in_area(pos1, pos2, 'air')
   if #air > 0 then
      local pick = math.random(1, #air)
      local ent = core.add_entity(air[pick], unit)
      return ent
   end
end

function ls_mobs.sort_targets(table)
   local highvalue = 0
   local highpos = {}
   for _, entry in pairs(table) do
      local node = core.get_node(entry)
      local value = core.get_item_group(node.name, 'attack')
      if value > highvalue then
         highvalue = value
         highpos = entry
      end
   end
   return highpos
end
