local tall_torch = {
   type = 'fixed',
   fixed = {-.125, -.5, -.125, .125, 1.25, .125}}

core.register_node('ls_crystal:torch_1', {
   description = 'Crystal Torch',
   drawtype = 'mesh',
   mesh = 'ls_crystal_torch.obj',
   tiles = {'ls_crystal_torch_1_uv.png'},
   paramtype = 'light',
   inventory_image = 'ls_crystal_torch_1_inv.png',
   groups = {breakable=4, non_blocking=1, torches=1, attack=2},
   light_source = 12,
   selection_box = tall_torch,
   collision_box = tall_torch,
   on_place = function(itemstack, placer, pointed_thing)
      local under = pointed_thing.under
      local above = pointed_thing.above
      local wdir = minetest.dir_to_wallmounted(vector.subtract(under, above))
      local fakestack = itemstack
      if wdir == 1 then
         fakestack:set_name('ls_crystal:torch_1')
      else
         fakestack:set_name('ls_crystal:torch_wall_1')
      end
      itemstack = minetest.item_place(fakestack, placer, pointed_thing, wdir)
      itemstack:set_name('ls_crystal:torch_1')
      return itemstack
   end,
   after_place_node = function(pos, placer)
      print 'placed node'
      local player_name = placer:get_player_name()
      local meta = core.get_meta(pos)
      meta:set_string('player_name', player_name)
      if ls_crystal.find_beacons(player_name, pos) == 0 then
         local timer = core.get_node_timer(pos)
         timer:start(600)
      end
   end,
   on_timer = function(pos)
      local node = core.get_node(pos)
      core.set_node(pos, {name='ls_crystal:torch_0'})
   end
})

core.register_node('ls_crystal:torch_0', {
   description = 'Crystal Torch (dead)',
   drawtype = 'mesh',
   mesh = 'ls_crystal_torch.obj',
   tiles = {'ls_crystal_torch_0_uv.png'},
   paramtype = 'light',
   inventory_image = 'ls_crystal_torch_0_inv.png',
   groups = {breakable=4, non_blocking=1, cookable=1},
   _cook_times = {14, 12, 8, 5},
   light_source = 5,
   selection_box = tall_torch,
   collision_box = tall_torch,
   on_place = function(itemstack, placer, pointed_thing)
      local under = pointed_thing.under
      local above = pointed_thing.above
      local wdir = core.dir_to_wallmounted(vector.subtract(under, above))
      local fakestack = itemstack
      if wdir == 1 then
         fakestack:set_name('ls_crystal:torch_0')
      else
         fakestack:set_name('ls_crystal:torch_wall_0')
      end
      itemstack = core.item_place(fakestack, placer, pointed_thing, wdir)
      itemstack:set_name('ls_crystal:torch_0')
      return itemstack
   end,
})

core.register_node('ls_crystal:torch_wall_1', {
   description = 'Crystal Torch',
   drawtype = 'mesh',
   mesh = 'ls_crystal_torch_wall.obj',
   tiles = {'ls_crystal_torch_0_uv.png'},
   paramtype = 'light',
   paramtype2 = 'wallmounted',
   groups = {breakable=4, torches=1, non_blocking=1, attached_node=1, attack=2},
   drop = 'ls_crystal:torch_1',
   light_source = 12,
   walkable = false,
   selection_box = {
      type = "wallmounted",
      wall_side = {-1/2, -1/2, -1/8, -1/8, 1/8, 1/8}},
   after_place_node = function(pos, placer)
      local player_name = placer:get_player_name()
      local meta = core.get_meta(pos)
      meta:set_string('player_name', player_name)
      if ls_crystal.find_beacons(player_name, pos) == 0 then
         local timer = core.get_node_timer(pos)
         timer:start(600)
      end
   end,
   on_timer = function(pos)
      local node = core.get_node(pos)
      core.set_node(pos, {name='ls_crystal:torch_wall_0'})
   end
})

core.register_node('ls_crystal:torch_wall_0', {
   description = 'Crystal Torch (dead)',
   drawtype = 'mesh',
   mesh = 'ls_crystal_torch_wall.obj',
   tiles = {'ls_crystal_torch_0_uv.png'},
   paramtype = 'light',
   paramtype2 = 'wallmounted',
   groups = {breakable=4, non_blocking=1, attached_node=1},
   drop = 'ls_crystal:torch_0',
   light_source = 5,
   walkable = false,
   selection_box = {
      type = "wallmounted",
      wall_side = {-1/2, -1/2, -1/8, -1/8, 1/8, 1/8}},
})
