core.register_node('ls_nodes:bed', {
   description = 'Bed (Sets Spawn)',
   drawtype = 'mesh',
   mesh = 'ls_nodes_bed.obj',
   tiles = {'ls_nodes_bed.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, .5, 0, 1.5},
               {-.5, 0, 1.35, .5, .5, 1.5}}
            },
   collision_box = {
      type = 'fixed',
      fixed = {{-.5, -.5, -.5, .5, 0, 1.5},
               {-.5, 0, 1.35, .5, .5, 1.5}}
            },
   groups = {breakable=1},
   after_place_node = function(pos, placer, itemstack)
      if not ls_core.space_to_front(pos) then
         core.remove_node(pos)
         return itemstack
      else
         local name = placer:get_player_name()
         ls_crystal.data[name].spawn = pos
      end
   end,
   after_dig_node = function(pos, oldnode)
      ls_core.remove_front_node(pos, oldnode)
   end,
   on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
      local name = clicker:get_player_name()
      ls_crystal.data[name].spawn = pos
      core.chat_send_player(name, 'Set your spawn point.')
      return itemstack
   end,
   on_rotate = function(pos, node)
      return false
   end,
})

core.register_node('ls_nodes:chest', {
   description = 'Chest',
   drawtype = 'mesh',
   mesh = 'ls_nodes_chest.obj',
   tiles = {'ls_nodes_chest.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.45, -.5, -.4, .45, .4, .5},
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.45, -.5, -.4, .45, .4, .5},
      },
   groups = {breakable=2, choppy=3},
   on_construct = function(pos)
      local meta = core.get_meta(pos)
      meta:set_string('formspec', ls_nodes.storage_form(pos, ''))
      local inv = meta:get_inventory()
      inv:set_size('main', 32)
   end,
   can_dig = function(pos,player)
      local meta = core.get_meta(pos)
      local inv = meta:get_inventory()
      return inv:is_empty('main')
   end,
   on_receive_fields = function(pos, formname, fields, sender)
      local player_name = sender:get_player_name()
      if core.is_protected(pos, player_name) and not core.check_player_privs(sender, 'protection_bypass') then
         return
      end
      local meta = core.get_meta(pos)
      if fields ['save'] then
         meta:set_string('infotext', fields.description)
         meta:set_string('formspec', ls_nodes.storage_form(pos, fields.description))
      end
   end,
   allow_metadata_inventory_put = ls_nodes.inv_take_put,
   allow_metadata_inventory_take = ls_nodes.inv_take_put,
   allow_metadata_inventory_move = ls_nodes.inv_manipulate,
   on_metadata_inventory_put = ls_nodes.inv_put,
   on_metadata_inventory_take = ls_nodes.inv_take,
})

core.register_node('ls_nodes:ladder', {
   description = 'Ladder',
   drawtype = 'mesh',
   mesh = 'ls_nodes_ladder.obj',
   tiles = {'ls_nodes_ladder.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   climbable = true,
   selection_box = {
      type = 'fixed',
         fixed = {
            {-.4, -.5, .3, .4, .5, .5},},
   },
   collision_box = {
      type = 'fixed',
         fixed = {
            {-.4, -.5, .3, .4, .5, .5},},
   },
   groups = {breakable=2, choppy=3},
})
