local function furnace_ui(player_name, pos)
   local meta = core.get_meta(pos)
   local beacon_count = ls_crystal.find_beacons(player_name, pos)
   local key = pos.x .. "," .. pos.y .. "," .. pos.z
   local formspec =
      'formspec_version[7]'..
      'size[11.25,5]'..
      'position[.5,.75]'..
      'anchor[.5,.5]'..
      'bgcolor[#000000;neither]'..
      'background[-1,-1;12.25,7;ls_crystal_beacon_bg.png;false]'..
      'style_type[textarea;textcolor=#93826e;font_size=+15]'..
      'textarea[.25,.25;9.75,2;;;This furnace is linked to '..beacon_count..' beacons.]'..
      'listcolors[#00000000;#ffffff25]'..
      ls_core.inv_slot_bg(.25,1,2,2)..
      'list[nodemeta:'..key..';input;.25,1;2,2]'.. --input
      ls_core.inv_slot_bg(6.5,1,3,2)..
      'list[nodemeta:'..key..';output;6.5,1;3,2]'.. --ouput
      ls_core.inv_slot_bg(.25,4,8,1)..
      'list[current_player;main;.25,4;8,1]'.. --player inv
      'listring[current_player;main]'..
      'listring[nodemeta:'..key..';input]'..
      'listring[current_player;main]'..
      'listring[nodemeta:'..key..';output]'..
      'listring[current_player;main]'
   core.show_formspec(player_name, 'ls_crystal:furnace', formspec)

end

--[[Cooking times in relation to number of links.
0 link  = 0x cooktime
1 links = 1x cooktime
2 links = .9x multipler
3 links = .75x cooktime
4 or more links = .5x multipler]]

local function count_input(pos)
   local count = 0
   local meta = core.get_meta(pos)
   local inv = meta:get_inventory()
   local stacks = inv:get_list('input')
   for k in pairs(stacks) do
      count = count + inv:get_stack('input', k):get_count()
   end
   return count
end

local function first_item(pos)
   local item = ''
   local meta = core.get_meta(pos)
   local inv = meta:get_inventory()
   local stacks = inv:get_list('input')
   for k in pairs(stacks) do
      if inv:get_stack('input', k):get_count() >= 1 then
         item = inv:get_stack('input', k):get_name()
         return item
      end
   end
end

local function cook_stuff(pos)
   local meta = minetest.get_meta(pos)
   local inv = meta:get_inventory()
   local stacks = inv:get_list('input')
   for k in pairs(stacks) do
      local stack = inv:get_stack('input', k)
      if not stack:is_empty() then
         local count = stack:get_count()
         if count <= 1 then
            inv:set_stack('input', k, '')
         else
            inv:set_stack('input', k, stack:get_name() .. ' ' .. (count - 1))
            break
         end
      end
   end
end

core.register_node('ls_crystal:furnace', {
   description = 'Furnace',
   tiles = {'ls_crystal_furnace_up.png', 'ls_crystal_furnace_down.png', 'ls_crystal_furnace_right.png', 'ls_crystal_furnace_left.png', 'ls_crystal_furnace_back.png', 'ls_crystal_furnace_front.png',},
   groups = {breakable=2, furnace=1, non_blocking=1, attack=8},
   light_source = 4,
   _break_time = 15,
   after_place_node = function(pos, placer)
      local meta = core.get_meta(pos)
      local player_name = placer:get_player_name()
      local inv = meta:get_inventory()
      meta:set_string('infotext', 'Furnace')
      meta:set_string('player_name', player_name)
      inv:set_size('input', 4)
      inv:set_size('output', 6)
   end,
   on_rightclick = function(pos, node, clicker)
      local player_name = clicker:get_player_name()
      local meta = core.get_meta(pos)
      local node_owner = meta:get_string('player_name')
      if node_owner == player_name then
         furnace_ui(player_name, pos)
      end
   end,
   allow_metadata_inventory_put = function(pos, listname, index, stack, player)
      local input = stack:get_name()
      if listname == 'input' then
         if core.get_item_group(input, 'cookable') > 0 then
            return 99
         else
            return 0
         end
      elseif listname == 'output' then
         return 0
      end
   end,
   on_metadata_inventory_put = function(pos, listname, index, stack, player)
      if listname == 'input' then
         if count_input(pos) > 0 then
            core.log('action', player:get_player_name()..' placed '..stack:get_name()..' into the asrs.')
            local timer = core.get_node_timer(pos)
            local beacon_count = math.min(4, (ls_crystal.find_beacons(player:get_player_name(), pos)))
            local input = stack:get_name()
            local def = core.registered_items[input]
            local cooktime = def._cook_times[beacon_count]
            timer:start(cooktime)
         end
      end
   end,
   --[[This needs to be made to work. :)
   on_metadata_inventory_take = function(pos, listname, index, stack, player)
      if listname == 'output' then
         local timer = core.get_node_timer(pos)
         local beacon_count = ls_crystal.find_beacons(player:get_player_name(), pos)
         local input = stack:get_name()
         local def = core.registered_items[input]
         local cooktime = def._cook_times[beacon_count]
         timer:start(cooktime)
      end
   end,]]
   on_timer = function(pos)
      local timer = core.get_node_timer(pos)
      local meta = core.get_meta(pos)
      local inv = meta:get_inventory()
      local input = inv:get_stack('input', 1)
      local input_name = first_item(pos)
      local input_count = input:get_count()
      if input_name == 'ls_items:metal_lump' and inv:room_for_item('output', 'ls_items:metal_ingot') then
         cook_stuff(pos)
         inv:add_item('output', 'ls_items:metal_ingot')
      elseif input_name == 'ls_items:meat_raw' and inv:room_for_item('output', 'ls_items:meat_cooked') then
         cook_stuff(pos)
         inv:add_item('output', 'ls_items:meat_cooked')
      elseif input_name == 'ls_crystal:lightshard_off' and inv:room_for_item('output', 'ls_crystal:lightshard_on') then
         cook_stuff(pos)
         inv:add_item('output', 'ls_crystal:lightshard_on')
      elseif input_name == 'ls_crystal:torch_0' and inv:room_for_item('output', 'ls_crystal:torch_1') then
         cook_stuff(pos)
         inv:add_item('output', 'ls_crystal:torch_1')
      end
      if count_input(pos) > 1 then
         local player_name = meta:get_string('player_name')
         local beacon_count = math.min(4, (ls_crystal.find_beacons(player_name, pos)))
         local def = core.registered_items[input_name]
         local cooktime = def._cook_times[beacon_count]
         timer:start(cooktime)
      end
   end,
})
