local tree_trunk = {
   type = 'fixed',
   fixed = {-.35, -1.5, -.35, .35, 1.5, .35}}

core.register_node('ls_map:tree_trunk', {
   description = 'Tree Trunk',
   tiles = {'ls_map_tree.png'},
   drawtype = 'mesh',
   mesh = 'ls_map_tree_trunk.obj',
   paramtype = 'light',
   param2 = 'facedir',
   groups = {breakable=2, chop=1},
   drop = '',
   selection_box = tree_trunk,
   collision_box = tree_trunk,
   node_dig_prediction = 'ls_map:tree_trunk',
   on_punch = function(pos, node, puncher)
      local tool = puncher:get_wielded_item()
      local tool_name = tool:get_name()
      if core.get_item_group(tool_name, 'axe') < 1 then
         local chance = math.random(0,10)
         if chance == 4 then
            local hp = puncher:get_hp()
            core.chat_send_player(puncher:get_player_name(), 'Try using a axe next time.')
            puncher:set_hp(hp - 1)
            chance = math.random(1,2)
            if chance == 2 then
               ls_core.add_inv(puncher, 'ls_items:log')
            end
         end
      end
   end,
   after_dig_node = function(pos, oldnode, oldmetadata, digger)
      local meta = core.get_meta(pos)
      if oldmetadata.fields.inv then
         local inv = tonumber(oldmetadata.fields.inv)
         if inv > 1 then
            core.swap_node(pos, {name = 'ls_map:tree_trunk'})
            meta:set_int('inv', inv - 1)
            ls_core.add_inv(digger, 'ls_items:log')
         elseif inv == 1 then
            local lower_pos = vector.add(pos, {x=0,y=-1,z=0})
            local above_pos = vector.add(pos, {x=0,y=3,z=0})
            core.remove_node(pos)
            core.remove_node(lower_pos)
            core.remove_node(above_pos)
            ls_core.add_inv(digger, 'ls_items:log')
            ls_core.add_xp(digger, 1)
         end
      else
         local inv = meta:get_int('inv')
         if inv == 0 then
            core.swap_node(pos, {name = 'ls_map:tree_trunk'})
            meta:set_int('inv', 14)
            ls_core.add_inv(digger, 'ls_items:log')
         end
      end
   end,
})

local tree_top = {
   type = 'fixed',
   fixed = {{-.35, -1.5, -.35, .35, 1.5, .35},
            {-1.5, -.5, -1.5, 1.5, 1.5, 1.5}}
   }

for i = 1,4 do
   core.register_node('ls_map:tree_top_'..i, {
      description = 'Tree Top',
      tiles = {'ls_map_tree.png'},
      drawtype = 'mesh',
      mesh = 'ls_map_tree_top_'..i..'.obj',
      paramtype = 'light',
      paramtype2 = 'degrotate',
      selection_box = tree_top,
      collision_box = tree_top,
   })
end
