function ls_crystal_beacon_overview(pos, player)
   local key = core.pos_to_string(pos)
   local data = ls_crystal.data[player][key]
   local links = data.links
   local varient = data.varient
   local var_string
   if varient == 'lr' then
      var_string = 'Long Range'
   elseif varient == 'sr' then
      var_string = 'Short Range'
   end
   local msg = ''
   if links == 0 then
      msg = 'Not linked to any other beacons!!!'
   elseif links == 1 then
      msg = 'This beacon only has one link, hurry, link it to more beacons to protect it from monster attacks.'
   elseif links == 2 then
      msg = 'This is better, two links makes an attack only half likely to succseed.'
   elseif links == 3 then
      msg = 'This beacon is pretty safe. It would take a strong, and stupid, monster to attempt to break the beacon.'
   elseif links >= 4 then
      msg = 'This beacon will last a long time. You connected enough other beacons to keep it safe from any attacks.'
   end
   local formspec =
      'formspec_version[7]'..
      'size[10,6]'..
      'position[.5,.75]'..
      'anchor[.5,.5]'..
      'bgcolor[#241e1550;true;#241e1550]'..
      'background[-1,-1;12,8;ls_core_10x6.png;false]'..
      'style_type[textarea;textcolor=#93826e;font_size=+15]'..
      'textarea[0,0;10,4;;;'..var_string..' Beacon ('..links..') links\n\n'..msg..']'
   return formspec
end

function ls_crystal_beacon_dead()
   local formspec =
      'formspec_version[7]'..
      'size[10,6]'..
      'position[.5,.75]'..
      'anchor[.5,.5]'..
      'bgcolor[#241e1550;true;#241e1550]'..
      'background[-1,-1;12,8;ls_core_10x6.png;false]'..
      'style_type[textarea;textcolor=#93826e;font_size=+15]'..
      'textarea[0,0;10,4;;;Dead Beacon. Punch with a lightshard crystal to repair it.]'
   return formspec
end
