local metal_box = {
   type = 'fixed',
   fixed = {-1, -.75, -1, 1, .5, 1}
   }

core.register_node('ls_map:metal_1', {
   description = 'Metal Mine',
   drawtype = 'mesh',
   mesh = 'ls_map_metal_1.obj',
   tiles = {'ls_map_metal_1.png'},
   paramtype = 'light',
   selection_box = metal_box,
   collision_box = metal_box,
   node_dig_prediction = 'ls_map:metal_1',
   groups = {metal=1},
   drop = '',
   on_punch = function(pos, node, puncher)
      local tool = puncher:get_wielded_item()
      local tool_name = tool:get_name()
      if core.get_item_group(tool_name, 'pickaxe') < 1 then
         local chance = math.random(0,6)
         if chance == 4 then
            local hp = puncher:get_hp()
            core.chat_send_player(puncher:get_player_name(), 'Try using a pickaxe next time.')
            puncher:set_hp(hp - 1)
         end
      end
   end,
   after_dig_node = function(pos, oldnode, oldmetadata, digger)
      local meta = core.get_meta(pos)
      if oldmetadata.fields.inv then
         local inv = tonumber( oldmetadata.fields.inv)
         if inv > 1 then
            core.swap_node(pos, {name = 'ls_map:metal_1'})
            meta:set_int('inv', inv - 1)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
         elseif inv == 1 then
            local chance = math.random(1,10)
            core.remove_node(pos)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
            ls_core.add_xp(digger, 2)
            if chance == 6 then
               ls_core.add_inv(digger, 'ls_crystal:lightshard_off')
            end
         end
      else
         local inv = meta:get_int('inv')
         if inv == 0 then
            core.swap_node(pos, {name = 'ls_map:metal_1'})
            meta:set_int('inv', 14)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
         end
      end
   end,
})

core.register_node('ls_map:metal_2', {
   description = 'Metal Mine',
   drawtype = 'mesh',
   mesh = 'ls_map_metal_2.obj',
   tiles = {'ls_map_metal_2.png'},
   paramtype = 'light',
   selection_box = metal_box,
   collision_box = metal_box,
   node_dig_prediction = 'ls_map:metal_2',
   groups = {metal=1},
   drop = '',
   on_punch = function(pos, node, puncher)
      local tool = puncher:get_wielded_item()
      local tool_name = tool:get_name()
      if core.get_item_group(tool_name, 'pickaxe') < 1 then
         local chance = math.random(0,6)
         if chance == 4 then
            local hp = puncher:get_hp()
            core.chat_send_player(puncher:get_player_name(), 'Try using a pickaxe next time.')
            puncher:set_hp(hp - 1)
         end
      end
   end,
   after_dig_node = function(pos, oldnode, oldmetadata, digger)
      local meta = core.get_meta(pos)
      if oldmetadata.fields.inv then
         local inv = tonumber( oldmetadata.fields.inv)
         if inv > 1 then
            core.swap_node(pos, {name = 'ls_map:metal_2'})
            meta:set_int('inv', inv - 1)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
         elseif inv == 1 then
            core.remove_node(pos)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
         end
      else
         local inv = meta:get_int('inv')
         if inv == 0 then
            local chance = math.random(1,10)
            core.swap_node(pos, {name = 'ls_map:metal_2'})
            meta:set_int('inv', 14)
            ls_core.add_inv(digger, 'ls_items:metal_lump')
            if chance == 7 then
               ls_core.add_inv(digger, 'ls_crystal:lightshard_off')
            end
         end
      end
   end,
})
