core.register_alias('mapgen_stone', 'ls_map:stone')
core.register_alias('mapgen_water', 'ls_map:dirt_4')

core.register_on_mapgen_init(function(mapgen_params)
   core.set_mapgen_setting('mg_flags', 'caves, nodungeons', true)
   core.set_mapgen_setting('mgflat_spflags', 'nolakes, hills, caverns', true)
   core.set_mapgen_setting('mgflat_ground_level', 1, true)
   --core.set_mapgen_setting('mgflat_lake_steepness', 48.0)
   core.set_mapgen_setting('mgflat_hill_threshold', .128)
   core.set_noiseparams('mg_biome_np_heat',     {lacunarity = 2, octaves = 2, spread = {z = 100, x = 100, y = 100}, seed = 5349, offset = 50, flags = "defaults", scale = 50, persist = 0.5, persistence = 0.5})
   core.set_noiseparams('mg_biome_np_humidity', {lacunarity = 2, octaves = 2, spread = {z = 100, x = 100, y = 100}, seed = 6874, offset = 50, flags = "defaults", scale = 50, persist = 0.5, persistence = 0.5})
end)


core.register_biome({
   name = 'mountains',
   node_top = 'ls_map:stone',
   depth_top = 4,
   node_filler = 'ls_map:stone',
   depth_filler = 4,
   y_max = 150,
   y_min = 25,
   heat_point = 50,
   humidity_point = 50,
})

core.register_biome({
   name = 'dirt',
   node_top = 'ls_map:dirt_4',
   depth_top = 4,
   node_filler = 'ls_map:stone',
   depth_filler = 4,
   y_max = 25,
   y_min = 0,
   heat_point = 50,
   humidity_point = 35,
   vertical_blend = 12,
})

core.register_biome({
   name = 'gravel',
   node_top = 'ls_map:gravel_4',
   depth_top = 4,
   node_filler = 'ls_map:gravel_4',
   depth_filler = 4,
   y_max = 10,
   y_min = -20,
   heat_point = 90,
   humidity_point = 5,
   vertical_blend = 2,
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4', 'ls_map:gravel_4'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.001,
         spread = {x = 1200, y = 2120, z = 1300},
         seed = 356684,
         octaves = 3,
         persist = .5,
         lacunarity = 2,
         flags = 'ease'
      },
      y_min = -20,
      y_max = 40,
      decoration = 'ls_map:stone_1',
      biomes = {'dirt', 'gravel'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4', 'ls_map:stone'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.001,
         spread = {x = 1400, y = 1400, z = 1400},
         seed = 158864,
         octaves = 3,
         persist = 1
      },
      y_min = -20,
      y_max = 40,
      decoration = 'ls_map:stone_2',
      biomes = {'dirt', 'mountains'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.001,
         spread = {x = 1400, y = 1400, z = 1400},
         seed = 1856584,
         octaves = 3,
         persist = 1
      },
      y_min = -20,
      y_max = 40,
      decoration = 'ls_map:metal_1',
      biomes = {'dirt', 'gravel'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4', 'ls_map:stone'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.001,
         spread = {x = 1400, y = 1400, z = 1400},
         seed = 57913584,
         octaves = 3,
         persist = 1
      },
      y_min = -20,
      y_max = 40,
      decoration = 'ls_map:metal_2',
      biomes = {'dirt', 'mountains'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4', 'ls_map:gravel_4'},
      sidelen = 16,
      noise_params = {
         offset = .001,
         scale = 0.0001,
         spread = {x = 1400, y = 1400, z = 1400},
         seed = 57913584,
         octaves = 3,
         persist = 1
      },
      y_min = -10,
      y_max = 20,
      decoration = 'ls_map:tree_trunk',
      param2 = 0,
      param2_max = 3,
      biomes = {'dirt', 'gravel'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:dirt_4'},
      sidelen = 16,
      noise_params = {
         offset = .025,
         scale = 0.0001,
         spread = {x = 400, y = 400, z = 400},
         seed = 53584,
         octaves = 3,
         persist = 1
      },
      y_min = -20,
      y_max = 50,
      decoration = 'ls_map:tree_trunk',
      param2 = 0,
      param2_max = 3,
      place_offset_y = 1,
      biomes = {'dirt'},
})

core.register_decoration({
      deco_type = 'simple',
      place_on = {'ls_map:gravel_4', 'ls_map:stone'},
      sidelen = 16,
      noise_params = {
         offset = .005,
         scale = 0.0001,
         spread = {x = 800, y = 800, z = 800},
         seed = 53584,
         octaves = 3,
         persist = 1
      },
      y_min = -20,
      y_max = 50,
      decoration = 'ls_map:tree_trunk',
      param2 = 0,
      param2_max = 3,
      place_offset_y = 1,
      biomes = {'gravel', 'mountains'},
})

core.register_ore({
   ore_type = 'blob',
   ore = 'ls_map:metal',
   wherein = 'ls_map:stone',
   clust_scarcity = 8*8*8,
   clust_num_ores = 12,
   clust_size = 2,
   y_min = -31000,
   y_max = -10,
   noise_params = {
        offset = 0,
        scale = 1,
        spread = {x = 100, y = 100, z = 100},
        seed = 23,
        octaves = 3,
        persistence = 0.7
    },
})

core.register_ore({
   ore_type = 'blob',
   ore = 'ls_map:metal',
   wherein = 'ls_map:stone',
   clust_scarcity = 8*8*8,
   clust_num_ores = 12,
   clust_size = 5,
   y_min = -31000,
   y_max = -150,
   noise_params = {
        offset = 0,
        scale = 1,
        spread = {x = 100, y = 100, z = 100},
        seed = 6845,
        octaves = 3,
        persistence = 0.7
    },
})
