local stone_box = {
   type = 'fixed',
   fixed = {{-1, -.75, -1, 1, .5, 1},
         {-.5, .5, -.5, .5, 1.5, .5}}
   }

core.register_node('ls_map:stone_1', {
   description = 'Stone Mine',
   drawtype = 'mesh',
   mesh = 'ls_map_stone_1.obj',
   tiles = {'ls_map_stone_1.png'},
   paramtype = 'light',
   selection_box = stone_box,
   collision_box = stone_box,
   node_dig_prediction = 'ls_map:stone_1',
   groups = {stone=1},
   drop = '',
   on_punch = function(pos, node, puncher)
      local tool = puncher:get_wielded_item()
      local tool_name = tool:get_name()
      if core.get_item_group(tool_name, 'pickaxe') < 1 then
         local chance = math.random(0,10)
         if chance == 4 then
            local hp = puncher:get_hp()
            core.chat_send_player(puncher:get_player_name(), 'Try using a pickaxe next time.')
            puncher:set_hp(hp - 1)
            chance = math.random(1,2)
            if chance == 2 then
               ls_core.add_inv(puncher, 'ls_items:stone')
            end
         end
      end
   end,
   after_dig_node = function(pos, oldnode, oldmetadata, digger)
      local meta = core.get_meta(pos)
      if oldmetadata.fields.inv then
         local inv = tonumber(oldmetadata.fields.inv)
         if inv > 1 then
            core.swap_node(pos, {name = 'ls_map:stone_1'})
            meta:set_int('inv', inv - 1)
            ls_core.add_inv(digger, 'ls_items:stone')
         elseif inv == 1 then
            local chance = math.random(1,25)
            core.remove_node(pos)
            ls_core.add_inv(digger, 'ls_items:stone')
            ls_core.add_xp(digger, 1)
            if chance == 21 then
               ls_core.add_inv(digger, 'ls_crystal:lightshard_off')
            end
         end
      else
         local inv = meta:get_int('inv')
         if inv == 0 then
            core.swap_node(pos, {name = 'ls_map:stone_1'})
            meta:set_int('inv', 14)
            ls_core.add_inv(digger, 'ls_items:stone')
         end
      end
   end,
})

core.register_node('ls_map:stone_2', {
   description = 'Stone Mine',
   drawtype = 'mesh',
   mesh = 'ls_map_stone_2.obj',
   tiles = {'ls_map_stone_2.png'},
   paramtype = 'light',
   selection_box = stone_box,
   collision_box = stone_box,
   node_dig_prediction = 'ls_map:stone_2',
   groups = {stone=1},
   drop = '',
   on_punch = function(pos, node, puncher)
      local tool = puncher:get_wielded_item()
      local tool_name = tool:get_name()
      if core.get_item_group(tool_name, 'pickaxe') < 1 then
         local chance = math.random(0,10)
         if chance == 4 then
            local hp = puncher:get_hp()
            core.chat_send_player(puncher:get_player_name(), 'Try using a pickaxe next time.')
            puncher:set_hp(hp - 1)
            chance = math.random(1,2)
            if chance == 2 then
               ls_core.add_inv(puncher, 'ls_items:stone')
            end
         end
      end
   end,
   after_dig_node = function(pos, oldnode, oldmetadata, digger)
      local meta = core.get_meta(pos)
      if oldmetadata.fields.inv then
         local inv = tonumber( oldmetadata.fields.inv)
         if inv > 1 then
            core.swap_node(pos, {name = 'ls_map:stone_2'})
            meta:set_int('inv', inv - 1)
            ls_core.add_inv(digger, 'ls_items:stone')
         elseif inv == 1 then
            core.remove_node(pos)
            ls_core.add_inv(digger, 'ls_items:stone')
         end
      else
         local inv = meta:get_int('inv')
         if inv == 0 then
            local chance = math.random(1,25)
            core.swap_node(pos, {name = 'ls_map:stone_2'})
            meta:set_int('inv', 14)
            ls_core.add_inv(digger, 'ls_items:stone')
            if chance == 21 then
               ls_core.add_inv(digger, 'ls_crystal:lightshard_off')
            end
         end
      end
   end,
})
