minetest.register_node('rob_opr_base:light_1', {
   description = 'light block',
   light_source = 14,
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_light_1.png'},
   groups = {oddly_breakable_by_hand = 3, lights = 1},
   flip = 'rob_opr_base:light_0'
})

minetest.register_node('rob_opr_base:light_0', {
   description = 'light block',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_light_1.png'},
   groups = {oddly_breakable_by_hand = 3, lights = 1, not_in_creative_inventory = 1},
   flip = 'rob_opr_base:light_1',
   drop = 'rob_opr_base:light_1'
})

minetest.register_node('rob_opr_base:light_helper', {
   description = 'Invisible light block',
   drawtype = 'airlike',
   pointable = false,
   walkable = false,
   light_source = 14,
   groups = {oddly_breakable_by_hand = 3, not_in_creative_inventory = 1},
})

minetest.register_node('rob_opr_base:highbay_light_on', {
   description = 'Highbay Lighting',
   light_source = 14,
   drawtype = 'mesh',
   mesh = 'rob_opr_base_highbay_lighting.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_highbay_lighting.png'},
   groups = {oddly_breakable_by_hand = 3, lights = 1},
   flip = 'rob_opr_base:highbay_light_off',
   on_construct = function(pos)
      local drop = vector.subtract(pos, {x=0, y=7, z=0})
      minetest.set_node(drop, {name = 'rob_opr_base:light_helper'})
   end,
   on_destruct = function(pos)
      local drop = vector.subtract(pos, {x=0, y=7, z=0})
      minetest.remove_node(drop)
   end,
})

minetest.register_node('rob_opr_base:highbay_light_off', {
   description = 'Highbay Lighting',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_highbay_lighting.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_highbay_lighting_off.png'},
   groups = {oddly_breakable_by_hand = 3, lights = 1, not_in_creative_inventory = 1},
   flip = 'rob_opr_base:highbay_light_on',
   drop = 'rob_opr_base:highbay_light_on',
   on_construct = function(pos)
      local drop = vector.subtract(pos, {x=0, y=7, z=0})
      minetest.remove_node(drop)
   end,
})

local exit_light = {
   type = 'fixed',
   fixed = {{-.375, -.4375, .5, .375, -.0625, .4375}}
}

minetest.register_node('rob_opr_base:exit_light', {
   description = 'Emergency Exit Light',
   light_source = 6,
   drawtype = 'mesh',
   mesh = 'rob_opr_base_exit_light.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_exit_light.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = exit_light,
   selection_box = exit_light,
})

local function swap_light(str_pos)
   local pos = minetest.string_to_pos(str_pos)
   local node = minetest.get_node(pos)
   local def = minetest.registered_nodes[node.name]
   local flip = def.flip
   if def.flip then
      minetest.set_node(pos, {name = flip, param2 = node.param2})
   end
end

local function lighting_control(pos)
   local meta = minetest.get_meta(pos)
   local lights = meta:get_string('light_pos')
   local formspec =
      'formspec_version[6]'..
      'size[16,9]'..
      'position[.5,.5]'..
      'no_prepend[]'..
      'bgcolor[#000000;false]'..
      'textarea[.5,.5;15,1;;;Let there be light(s) :D]'..
      'textarea[.5,2;15,4;light_pos;Position(s) of light(s) to control.;'..lights..']'..
      'button[.5,7.5;3,1;paste;Overwrite]'..
      'button[4.5,7.5;3,1;clear;Clear]'..
      'button[8.5,7.5;3,1;save;Save]'..
      'button_exit[12.5,7.5;3,1;exit;Exit]'
   return formspec
end

local power_r_switch = {
   type = 'fixed',
   fixed = {{-.375, -.375, .5, -.25, -.1875, .4375}}
}

local high_voltage_switch_replies = {
   '[It looks like this is a high voltage power switch.]',
   '[This switch probably turns on highbay lighting.]',
}

minetest.register_node('rob_opr_base:power_switch_hv', {
   description = 'Power Switch (High Voltage)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_power_switch_hv.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_power_switch_hv.png'},
   groups = {oddly_breakable_by_hand=3, configure=1},
   collision_box = power_r_switch,
   selection_box = power_r_switch,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1001'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(high_voltage_switch_replies))))
   end,
   _on_use = function(pos, name)
      minetest.close_formspec(name, 'action_menu')
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
   end,
   _on_configure = function(pos, name)
      rob_opr_base.config[name] = pos
      minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
   end,
})

low_voltage_switch_replies = {
   '[Well there is no hidden camera in this power switch.]',
   '[Looks like a standard light switch to me.]',
   '[This probably toggles lights someplace.]',
   '[There is a low chance that this could be wired wrong and will electrocute me if I touch it.]',
   '[This looks an awful lot like an Eaton 15A white rocker, single pole residential light switch. Odd that it is being used in an industrial setting.]'
}

minetest.register_node('rob_opr_base:power_switch_lv_off', {
   description = 'Power Switch (Low, technically standard, 120 Voltage)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_power_switch_l_lv_off.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_power_switch_lv.png'},
   groups = {oddly_breakable_by_hand=3, configure=1},
   collision_box = power_r_switch,
   selection_box = power_r_switch,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1001'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(low_voltage_switch_replies))))
   end,
   _on_use = function(pos, name)
      rob_opr_base.adjust_alert_level(name, 1)
      minetest.close_formspec(name, 'action_menu')
      local node = minetest.get_node(pos)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_lv_on', param2 = node.param2})
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_lv_on', param2 = node.param2})
   end,
   _on_configure = function(pos, name)
      rob_opr_base.config[name] = pos
      minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
   end,
})

minetest.register_node('rob_opr_base:power_switch_lv_on', {
   description = 'Power Switch (Low, technically standard, 120 Voltage)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_power_switch_l_lv_on.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_power_switch_lv.png'},
   groups = {oddly_breakable_by_hand=3, configure=1, not_in_creative_inventory = 1},
   drop = 'rob_opr_base:power_switch_lv_off',
   collision_box = power_r_switch,
   selection_box = power_r_switch,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1001'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(low_voltage_switch_replies))))
   end,
   _on_use = function(pos, name)
      rob_opr_base.adjust_alert_level(name, 1)
      minetest.close_formspec(name, 'action_menu')
      local node = minetest.get_node(pos)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_lv_off', param2 = node.param2})
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_lv_off', param2 = node.param2})
   end,
   _on_configure = function(pos, name)
      rob_opr_base.config[name] = pos
      minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
   end,
})

local power_l_switch = {
   type = 'fixed',
   fixed = {{.375, -.375, .5, .25, -.1875, .4375}}
}

minetest.register_node('rob_opr_base:power_switch_r_lv_off', {
   description = 'Power Switch (Low, technically standard, 120 Voltage)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_power_switch_r_lv_off.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_power_switch_lv.png'},
   groups = {oddly_breakable_by_hand=3, configure=1},
   collision_box = power_l_switch,
   selection_box = power_l_switch,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1001'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(low_voltage_switch_replies))))
   end,
   _on_use = function(pos, name)
      rob_opr_base.adjust_alert_level(name, 1)
      minetest.close_formspec(name, 'action_menu')
      local node = minetest.get_node(pos)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_r_lv_on', param2 = node.param2})
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_r_lv_on', param2 = node.param2})
   end,
   _on_configure = function(pos, name)
      rob_opr_base.config[name] = pos
      minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
   end,
})

minetest.register_node('rob_opr_base:power_switch_r_lv_on', {
   description = 'Power Switch (Low, technically standard, 120 Voltage)',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_power_switch_r_lv_on.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_power_switch_lv.png'},
   groups = {oddly_breakable_by_hand=3, configure=1, not_in_creative_inventory = 1},
   drop = 'rob_opr_base:power_switch_l_lv_off',
   collision_box = power_l_switch,
   selection_box = power_l_switch,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1001'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(low_voltage_switch_replies))))
   end,
   _on_use = function(pos, name)
      rob_opr_base.adjust_alert_level(name, 1)
      minetest.close_formspec(name, 'action_menu')
      local node = minetest.get_node(pos)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_r_lv_off', param2 = node.param2})
   end,
   on_punch = function(pos, node, puncher)
      local name = puncher:get_player_name()
      rob_opr_base.adjust_alert_level(name, 1)
      local meta = minetest.get_meta(pos)
      local lights = meta:get_string('light_pos')
      for pos in lights:gmatch('%([^%)]+%)') do
         swap_light(pos)
      end
      minetest.swap_node(pos, {name = 'rob_opr_base:power_switch_r_lv_off', param2 = node.param2})
   end,
   _on_configure = function(pos, name)
      rob_opr_base.config[name] = pos
      minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
   end,
})

minetest.register_on_player_receive_fields(function(player, formname, fields)
   if formname == 'lighting_control' then
      local name = player:get_player_name()
      local pos = rob_opr_base.config[name]
      local meta = minetest.get_meta(pos)
      if fields.paste then
         meta:set_string('light_pos', rob_opr_base.lights[name])
         minetest.show_formspec(name, 'lighting_control', lighting_control(pos))
      elseif fields.clear then
         rob_opr_base.lights[name] = ''
      elseif fields.save then
         meta:set_string('light_pos', fields.light_pos)
      end
   end
end)
