local railing = {
   type = 'fixed',
   fixed = {{-.5, -.5, .375, .5, .5, .25}}
}

minetest.register_node('rob_opr_base:rail_l', {
   description = 'Railing with termination on the left',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_rail_l.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_railing.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = railing,
   selection_box = railing,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
   end
})

minetest.register_node('rob_opr_base:rail_c', {
   description = 'Railing',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_rail_c.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_railing.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = railing,
   selection_box = railing,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
   end
})

minetest.register_node('rob_opr_base:rail_r', {
   description = 'Railing with termination on the right',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_rail_r.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_railing.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = railing,
   selection_box = railing,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
   end
})

local corner_post = {
   type = 'fixed',
   fixed = {{-.5, -.5, .1875, -.1875, .5, .5}}
}

minetest.register_node('rob_opr_base:rail_corner', {
   description = 'Corner post for railing',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_rail_corner.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_railing.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = corner_post,
   selection_box = corner_post,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1111'))
   end
})

local restroom_sign = {
   type = 'fixed',
      fixed = {{-.46875, -.1875, .5, .46875, .4375, .46875}}
}

minetest.register_node('rob_opr_base:restroom_sign_1', {
   description = 'Restroom Sign',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_restroom_sign.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_restroom_sign_1.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = restroom_sign,
   selection_box = restroom_sign,
})

minetest.register_node('rob_opr_base:restroom_sign_2', {
   description = 'Restroom Sign',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_restroom_sign.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_restroom_sign_2.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = restroom_sign,
   selection_box = restroom_sign,
})

minetest.register_node('rob_opr_base:locker_room_men', {
   description = 'Men\'s Locker room sign',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_restroom_sign.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_locker_room_mens.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = restroom_sign,
   selection_box = restroom_sign,
})

minetest.register_node('rob_opr_base:locker_room_women', {
   description = 'Women\'s Locker room sign',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_restroom_sign.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_locker_room_womens.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = restroom_sign,
   selection_box = restroom_sign,
})

local locker_contents = {
   '[Neat, a dirty old work uniform, sheesh it smells funny too.]',
   '[Hey, some shoes, they look pretty new too, but clearly have been worn]',
   '[No way, this guy has a toothbrush and toothpaste in his locker.]',
   '[Cool, a bottle of water, aww, it\'s already opened.]',
   '[Wow, these are some nice safety glasses, oh, looks like a perscription pair.]'
}

local locker_report_replies = {
   '{That\'s not so terribly unusual, see if there is anything in them.}',
   '{Where did you think employees would keep their stuff, just dump it on the floor?}',
   '{You are aware that we have lockers in the office too.}',
   '{You always act as if the most mundane things are so important.}',
   '{Why do I always get stuck working with you?}',
   '{For just once I wish you would stop being so stupid.}',
   '{Seriously, you need to focus on the task at hand.}'
}

local locker_bottom = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.25, 0, 1.5, .5}}
}

minetest.register_node('rob_opr_base:locker_left', {
   description = 'Storage Locker',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_locker.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_locker.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = locker_bottom,
   selection_box = locker_bottom,
   on_construct = function(pos)
      local node = minetest.get_node(pos)
      minetest.set_node(vector.add(pos, {x=0, y=1, z=0}), {name = 'rob_opr_base:locker_right', param2 = node.param2})
   end,
   on_destruct = function(pos)
      minetest.swap_node(vector.add(pos, {x=0, y=1, z=0}), {name = 'air'})
   end,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1010'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(locker_contents))))
   end,
   _on_report = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#49adff', rob_opr_base.random_chat(locker_report_replies))))
      rob_opr_base.adjust_anger(name, 2)
   end,
})

local locker_top = {
   type = 'fixed',
   fixed = {{0, -1.5, -.25, .5, .5, .5}}
}

minetest.register_node('rob_opr_base:locker_right', {
   description = 'Storage Locker',
   drawtype = 'airlike',
   paramtype2 = 'facedir',
   collision_box = locker_top,
   selection_box = locker_top,
   groups = {not_in_creative_inventory=1, oddly_breakable_by_hand = 3},
   drop = 'rob_opr_base:locker_left',
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1010'))
   end,
   on_destruct = function(pos)
      minetest.swap_node(vector.subtract(pos, {x=0, y=1, z=0}), {name = 'air'})
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(locker_contents))))
   end,
   _on_report = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#49adff', rob_opr_base.random_chat(locker_report_replies))))
      rob_opr_base.adjust_anger(name, 2)
   end,
})

local locker_bench = {
   type = 'fixed',
   fixed = {{-.9375, -.5, -.3125, .9375, 0, .3125}}
}

local bench_review = {
   '[This is a really well made bench.]',
   '[I bent I could park a truck on this and it wouldn\'t break.]',
   '[I could use one of these in my gym.]',
   '[If this wasn\'t bolted to the floor it would make a GREAT weapon.]'
}

minetest.register_node('rob_opr_base:locker_bench', {
   description = 'Locker Room Bench',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_locker_bench.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   tiles = {'rob_opr_base_locker_bench.png'},
   groups = {oddly_breakable_by_hand = 3},
   collision_box = locker_bench,
   selection_box = locker_bench,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1100'))
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', rob_opr_base.random_chat(bench_review))))
   end,
   _on_take = function(pos, name, player)
      minetest.chat_send_player(name, (minetest.colorize('#ff0000', '<Ain\'t no way this is budging.>')))
   end
})


minetest.register_node('rob_opr_base:desk', {
   description = 'Desk',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_desk.obj',
   tiles = {'rob_opr_base_desk.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5}
   },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, 1.5, .5, .5}
   },
   groups = {oddly_breakable_by_hand=3},
})

minetest.register_node('rob_opr_base:laptop', {
   description = 'Laptop',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_laptop.obj',
   tiles = {'rob_opr_base_laptop.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   selection_box = {
      type = 'fixed',
      fixed = {{-.45, -.5, -.35, .45, -.45, .35},
               {-.45, -.45, .25, .45, .15, .5}}
      },
   collision_box = {
      type = 'fixed',
      fixed = {{-.45, -.5, -.35, .45, -.45, .35},
               {-.45, -.45, .25, .45, .15, .5}}
      },
   groups = {oddly_breakable_by_hand=3},
})

minetest.register_node('rob_opr_base:counter', {
   description = 'Bathroom counter',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_counter.obj',
   tiles = {'rob_opr_base_counter.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {oddly_breakable_by_hand=3},
})

minetest.register_node('rob_opr_base:counter_sink', {
   description = 'Bathroom counter with sink',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_counter_sink.obj',
   tiles = {'rob_opr_base_counter_sink.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {oddly_breakable_by_hand=3},
})

minetest.register_node('rob_opr_base:ladder', {
   description = 'Ladder',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_ladder.obj',
   tiles = {'rob_opr_base_ladder.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   walkable = false,
   climbable = true,
   selection_box = {
      type = 'fixed',
      fixed = {-.5, -.5, .25, .5, .5, .5}
      },
   collision_box = {
      type = 'fixed',
      fixed = {-.5, -.5, -.5, .5, .5, .5}
      },
   groups = {oddly_breakable_by_hand=3},
})
