function rob_opr_base.trigger_alarm(pos)
   local pos = pos or {x=0, y=0, z=0}
   local pos1 = vector.add(pos, {x=15, y=2, z=15})
   local pos2 = vector.subtract(pos, {x=15, y=2, z=15})
   local spawns = minetest.find_nodes_in_area(pos1, pos2, 'rob_opr_base:drone_dock')
   for _, pos in ipairs(spawns) do
      minetest.add_entity(pos, 'rob_opr_base:drone_assassin')
   end
end

function rob_opr_base.send_cleaners(pos)
   local pos = pos or {x=0, y=0, z=0}
   local pos1 = vector.add(pos, {x=15, y=1, z=15})
   local pos2 = vector.subtract(pos, {x=15, y=5, z=15})
   local spawns = minetest.find_nodes_in_area(pos1, pos2, 'rob_opr_base:drone_dock')
   for _, pos in ipairs(spawns) do
      minetest.add_entity(pos, 'rob_opr_base:drone_security')
   end
end

local docking_station = {
   type = 'fixed',
   fixed = {{-.1875, -.5, .375, .1875, 0, .5}}
}

minetest.register_node('rob_opr_base:drone_dock', {
   description = 'Drone Dock',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_drone_dock.obj',
   tiles = {'rob_opr_base_drone_dock.png'},
   paramtype = 'light',
   paramtype2 = 'facedir',
   groups = {oddly_breakable_by_hand = 3},
   collision_box = docking_station,
   selection_box = docking_station,
   on_rightclick = function(pos, node, clicker)
      local name = clicker:get_player_name()
      rob_opr_base.act_menu[name] = pos
      minetest.show_formspec(name, 'action_menu', rob_opr_base.action_menu('1110'))
   end,
   _on_report = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#49adff', '{A robot vacuum docking station? Probably not anything to worry about.}')))
      rob_opr_base.adjust_anger(name, 1)
   end,
   _on_inspect = function(pos, name)
      minetest.chat_send_player(name, (minetest.colorize('#28b928', '[Looks to be some sort of docking station.]')))
      rob_opr_base.adjust_alert_level(name, 3)
   end,
   _on_take = function(pos, name, player)
      minetest.chat_send_player(name, (minetest.colorize('#ff0000', '<I don\'t really need this.>')))
   end
})



minetest.register_entity('rob_opr_base:drone_security', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'rob_opr_base_drone_security.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collisionbox = {-.25, -.5, -.25, .25, -.325, .25},
      textures = {'rob_opr_base_drone_security.png'},
      glow = 1,
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      self.object:set_velocity({x=0, y=0, z=-1})
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         local pos = vector.round(self.object:get_pos())
         local below_pos = vector.subtract(pos, {x=0, y=1, z=0})
         local below_node = minetest.get_node(below_pos).name
         if below_node == 'air' then
            local vel = self.object:get_velocity()
            self.object:set_velocity({x=0, y=-9.8, z=0})
         end
      end

      if moveresults.collides then
         local hit_object = moveresults.collisions[1] and moveresults.collisions[1].type == 'object'
         if hit_object then
            local bump = moveresults.collisions[1].object
            local velocity = moveresults.collisions[1].old_velocity
            bump:set_velocity(velocity)
            if minetest.is_player(moveresults.collisions[1].object) then
               local pos = self.object:get_pos()
               rob_opr_base.trigger_alarm(pos)
            end
         end
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * 1)
               }
            self.object:set_velocity(new_vel)
         end
      end
   end,

   on_punch = function(self, puncher)
      local pos = self.object:get_pos()
      rob_opr_base.trigger_alarm(pos)
   end,
})

minetest.register_entity('rob_opr_base:drone_assassin', {
   initial_properties = {
      visual = 'mesh',
      mesh = 'rob_opr_base_drone_assassin.obj',
      visual_size = {x=10, y=10},
      physical = true,
      collisionbox = {-.25, -.5, -.25, .25, -.325, .25},
      textures = {'rob_opr_base_drone_assassin.png'},
      automatic_face_movement_dir = 0.0,
   },

   on_activate = function(self, staticdata, dtime_s)
      self.object:set_velocity({x=0, y=0, z=-1})
   end,

   on_step = function(self, dtime, moveresults)
      self.node_timer = (self.node_timer or 0) + dtime
      if self.node_timer > 1 then
         self.node_timer = 0
         local pos = vector.round(self.object:get_pos())
         local below_pos = vector.subtract(pos, {x=0, y=1, z=0})
         local below_node = minetest.get_node(below_pos).name
         if below_node == 'air' then
            local vel = self.object:get_velocity()
            self.object:set_velocity({x=0, y=-9.8, z=0})
         end
      end
      --Maybe add pathfinding to this drone to hunt down the player
      if moveresults.collides then
         local hit_object = moveresults.collisions[1] and moveresults.collisions[1].type == 'object'
         if hit_object then
            local bump = moveresults.collisions[1].object
            local velocity = moveresults.collisions[1].old_velocity
            bump:set_velocity(velocity)
            if minetest.is_player(moveresults.collisions[1].object) then
               local player = moveresults.collisions[1].object
               local name = player:get_player_name()
               local pos = self.object:get_pos()
               rob_opr_base.trigger_alarm(pos)
               local chance = math.random(10)
               if chance == 1 then --Player dies, game ends.
                  minetest.clear_objects('quick')
                  minetest.show_formspec(name, 'end_screen', rob_opr_base.end_game_lose)
               end
            end
         end
         local hit_node = moveresults.collisions[1] and moveresults.collisions[1].type == 'node'
         if hit_node then
            local yaw = self.object:get_yaw()
            local x_yaw_random = math.random()
            local z_yaw_random = math.random()
            local new_vel = {
                  x = (math.sin(yaw + x_yaw_random) * -1.5),
                  y = 0,
                  z = (math.cos(yaw + z_yaw_random) * -1.5)
               }
            self.object:set_velocity(new_vel)
         end
      end
   end,

   on_punch = function(self, puncher)
      local pos = self.object:get_pos()
      rob_opr_base.trigger_alarm(pos)
   end,
})
