local col_box = {
   type = 'fixed',
   fixed = {{-.5, -.5, -.125 ,.5, .5, .125}}
}

minetest.register_node('rob_opr_base:ceiling_support', {
   description = 'Steel girders to hold up a ceiling',
   drawtype = 'mesh',
   mesh = 'rob_opr_base_ceiling_support.obj',
   paramtype = 'light',
   paramtype2 = 'facedir',
   collision_box = col_box,
   selection_box = col_box,
   tiles = {'rob_opr_base_ceiling_support.png'},
   groups = {oddly_breakable_by_hand = 3},
   after_place_node = function(pos, placer, itemstack)
      local node = minetest.get_node(pos)
      local fdir = node.param2
      local length = 0
      if fdir == 1 then -- negative z
         local pos1 = {x=pos.x, y=pos.y, z=pos.z-1}
         local pos1_name = minetest.get_node(pos1).name
         while pos1_name == 'air' and length <= 20 do
            length = length + 1
            pos1 = {x=pos1.x, y=pos1.y, z=pos1.z-1}
            pos1_name = minetest.get_node(pos1).name
         end
         for i = 1, (length) do
            if i%2 ~= 0 then
               fdir = 3
            else
               fdir = 1
            end
            local place_pos = {x=pos.x, y=pos.y, z=pos.z-i}
            minetest.set_node(place_pos, {name = 'rob_opr_base:ceiling_support', param2 = fdir})
         end
      elseif fdir == 2 then -- negative x
         local pos1 = {x=pos.x-1, y=pos.y, z=pos.z}
         local pos1_name = minetest.get_node(pos1).name
         while pos1_name == 'air' and length <= 20 do
            length = length + 1
            pos1 = {x=pos1.x-1, y=pos1.y, z=pos1.z}
            pos1_name = minetest.get_node(pos1).name
         end
         for i = 1, (length) do
            if i%2 ~= 0 then
               fdir = 0
            else
               fdir = 2
            end
            local place_pos = {x=pos.x-i, y=pos.y, z=pos.z}
            minetest.set_node(place_pos, {name = 'rob_opr_base:ceiling_support', param2 = fdir})
         end
      elseif fdir == 3 then -- positive z
         local pos1 = {x=pos.x, y=pos.y, z=pos.z+1}
         local pos1_name = minetest.get_node(pos1).name
         while pos1_name == 'air' and length <= 10 do
            length = length + 1
            pos1 = {x=pos1.x, y=pos1.y, z=pos1.z+1}
            pos1_name = minetest.get_node(pos1).name
         end
         for i = 1, (length) do
            if i%2 ~= 0 then
               fdir = 1
            else
               fdir = 3
            end
            local place_pos = {x=pos.x, y=pos.y, z=pos.z+i}
            minetest.set_node(place_pos, {name = 'rob_opr_base:ceiling_support', param2 = fdir})
         end

      elseif fdir == 0 then -- positive x
         local pos1 = {x=pos.x+1, y=pos.y, z=pos.z}
         local pos1_name = minetest.get_node(pos1).name
         while pos1_name == 'air' and length <= 10 do
            length = length + 1
            pos1 = {x=pos1.x+1, y=pos1.y, z=pos1.z}
            pos1_name = minetest.get_node(pos1).name
         end
         for i = 1, (length) do
            if i%2 ~= 0 then
               fdir = 0
            else
               fdir = 2
            end
            local place_pos = {x=pos.x+i, y=pos.y, z=pos.z}
            minetest.set_node(place_pos, {name = 'rob_opr_base:ceiling_support', param2 = fdir})
         end
      end
   end,
})
